/*
 * Decompiled with CFR 0.152.
 */
package brut.androlib.res.decoder;

import brut.androlib.exceptions.AndrolibException;
import brut.androlib.exceptions.NinePatchNotFoundException;
import brut.androlib.res.data.LayoutBounds;
import brut.androlib.res.data.NinePatchData;
import brut.androlib.res.decoder.ResStreamDecoder;
import brut.util.BinaryDataInputStream;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.awt.image.WritableRaster;
import java.io.ByteArrayInputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteOrder;
import javax.imageio.ImageIO;
import org.apache.commons.io.IOUtils;

public class ResNinePatchStreamDecoder
implements ResStreamDecoder {
    @Override
    public void decode(InputStream in, OutputStream out) throws AndrolibException {
        try {
            byte[] data = IOUtils.toByteArray(in);
            if (data.length == 0) {
                return;
            }
            BufferedImage src = ImageIO.read(new ByteArrayInputStream(data));
            int w = src.getWidth();
            int h = src.getHeight();
            BufferedImage dst = new BufferedImage(w + 2, h + 2, 2);
            if (src.getType() == 0) {
                WritableRaster srcRaster = src.getRaster();
                WritableRaster dstRaster = dst.getRaster();
                int[] gray = null;
                int[] alpha = null;
                for (int y = 0; y < src.getHeight(); ++y) {
                    gray = srcRaster.getSamples(0, y, w, 1, 0, gray);
                    alpha = srcRaster.getSamples(0, y, w, 1, 1, alpha);
                    dstRaster.setSamples(1, y + 1, w, 1, 0, gray);
                    dstRaster.setSamples(1, y + 1, w, 1, 1, gray);
                    dstRaster.setSamples(1, y + 1, w, 1, 2, gray);
                    dstRaster.setSamples(1, y + 1, w, 1, 3, alpha);
                }
            } else {
                dst.createGraphics().drawImage(src, 1, 1, w, h, null);
            }
            NinePatchData np = this.findNinePatchData(data);
            this.drawHLine(dst, h + 1, np.paddingLeft + 1, w - np.paddingRight);
            this.drawVLine(dst, w + 1, np.paddingTop + 1, h - np.paddingBottom);
            int[] xDivs = np.xDivs;
            if (xDivs.length == 0) {
                this.drawHLine(dst, 0, 1, w);
            } else {
                for (int i = 0; i < xDivs.length; i += 2) {
                    this.drawHLine(dst, 0, xDivs[i] + 1, xDivs[i + 1]);
                }
            }
            int[] yDivs = np.yDivs;
            if (yDivs.length == 0) {
                this.drawVLine(dst, 0, 1, h);
            } else {
                for (int i = 0; i < yDivs.length; i += 2) {
                    this.drawVLine(dst, 0, yDivs[i] + 1, yDivs[i + 1]);
                }
            }
            try {
                int y;
                int x;
                int i;
                LayoutBounds lb = this.findLayoutBounds(data);
                for (i = 0; i < lb.left; ++i) {
                    x = 1 + i;
                    dst.setRGB(x, h + 1, -65536);
                }
                for (i = 0; i < lb.right; ++i) {
                    x = w - i;
                    dst.setRGB(x, h + 1, -65536);
                }
                for (i = 0; i < lb.top; ++i) {
                    y = 1 + i;
                    dst.setRGB(w + 1, y, -65536);
                }
                for (i = 0; i < lb.bottom; ++i) {
                    y = h - i;
                    dst.setRGB(w + 1, y, -65536);
                }
            }
            catch (NinePatchNotFoundException ninePatchNotFoundException) {
                // empty catch block
            }
            ImageIO.write((RenderedImage)dst, "png", out);
        }
        catch (IOException | NullPointerException ex) {
            throw new AndrolibException(ex);
        }
    }

    private NinePatchData findNinePatchData(byte[] data) throws NinePatchNotFoundException, IOException {
        BinaryDataInputStream in = new BinaryDataInputStream(data, ByteOrder.BIG_ENDIAN);
        this.findChunk(in, 1852855395);
        return NinePatchData.read(in);
    }

    private LayoutBounds findLayoutBounds(byte[] data) throws NinePatchNotFoundException, IOException {
        BinaryDataInputStream in = new BinaryDataInputStream(data, ByteOrder.BIG_ENDIAN);
        this.findChunk(in, 1852853346);
        return LayoutBounds.read(in);
    }

    private void findChunk(BinaryDataInputStream in, int magic) throws NinePatchNotFoundException, IOException {
        in.skipBytes(8);
        while (true) {
            int size;
            try {
                size = in.readInt();
            }
            catch (EOFException ignored) {
                throw new NinePatchNotFoundException();
            }
            if (in.readInt() == magic) {
                return;
            }
            in.skipBytes(size + 4);
        }
    }

    private void drawHLine(BufferedImage im, int y, int x1, int x2) {
        for (int x = x1; x <= x2; ++x) {
            im.setRGB(x, y, -16777216);
        }
    }

    private void drawVLine(BufferedImage im, int x, int y1, int y2) {
        for (int y = y1; y <= y2; ++y) {
            im.setRGB(x, y, -16777216);
        }
    }
}

