/*
 * Decompiled with CFR 0.152.
 */
package brut.util;

import com.google.common.io.ByteStreams;
import com.google.common.primitives.Ints;
import com.google.common.primitives.Longs;
import java.io.ByteArrayInputStream;
import java.io.DataInput;
import java.io.EOFException;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteOrder;

public class BinaryDataInputStream
extends FilterInputStream
implements DataInput {
    private final ByteOrder mByteOrder;
    private final long mLimit;
    private long mPosition;
    private long mMark;

    public BinaryDataInputStream(byte[] in) {
        this((InputStream)new ByteArrayInputStream(in), in.length);
    }

    public BinaryDataInputStream(byte[] in, ByteOrder bo) {
        this(new ByteArrayInputStream(in), bo, in.length);
    }

    public BinaryDataInputStream(InputStream in) {
        this(in, ByteOrder.LITTLE_ENDIAN, Long.MAX_VALUE);
    }

    public BinaryDataInputStream(InputStream in, long limit) {
        this(in, ByteOrder.LITTLE_ENDIAN, limit);
    }

    public BinaryDataInputStream(InputStream in, ByteOrder bo) {
        this(in, bo, Long.MAX_VALUE);
    }

    public BinaryDataInputStream(InputStream in, ByteOrder bo, long limit) {
        super(in);
        this.mByteOrder = bo;
        this.mLimit = limit;
        this.mMark = -1L;
    }

    public ByteOrder order() {
        return this.mByteOrder;
    }

    public long limit() {
        return this.mLimit;
    }

    public long position() {
        return this.mPosition;
    }

    public long remaining() {
        return this.mLimit - this.mPosition;
    }

    public long jumpTo(long pos) throws IOException {
        long expected = pos - this.mPosition;
        if (expected == 0L) {
            return 0L;
        }
        if (expected < 0L) {
            throw new IOException(String.format("Illegal backwards jump from %s to %s", this.mPosition, pos));
        }
        long skipped = this.skip(expected);
        if (skipped != expected) {
            throw new IOException(String.format("Jump failed: skipped %s bytes (expected: %s)", skipped, expected));
        }
        return skipped;
    }

    public void skipByte() throws IOException {
        this.readByte();
    }

    public void skipShort() throws IOException {
        this.readShort();
    }

    public void skipInt() throws IOException {
        this.readInt();
    }

    public void skipLong() throws IOException {
        this.readLong();
    }

    public byte[] readBytes(int len) throws IOException {
        byte[] buf = new byte[len];
        this.readFully(buf);
        return buf;
    }

    public short[] readShortArray(int len) throws IOException {
        short[] arr = new short[len];
        for (int i = 0; i < len; ++i) {
            arr[i] = this.readShort();
        }
        return arr;
    }

    public int[] readIntArray(int len) throws IOException {
        int[] arr = new int[len];
        for (int i = 0; i < len; ++i) {
            arr[i] = this.readInt();
        }
        return arr;
    }

    public long[] readLongArray(int len) throws IOException {
        long[] arr = new long[len];
        for (int i = 0; i < len; ++i) {
            arr[i] = this.readLong();
        }
        return arr;
    }

    public String readAscii(int len) throws IOException {
        char ch;
        char[] buf = new char[len];
        int pos = 0;
        while (len-- > 0 && (ch = (char)this.readUnsignedByte()) != '\u0000') {
            buf[pos++] = ch;
        }
        if (len > 0) {
            this.skipBytes(len);
        }
        return new String(buf, 0, pos);
    }

    public String readUtf16(int len) throws IOException {
        char ch;
        char[] buf = new char[len];
        int pos = 0;
        while (len-- > 0 && (ch = this.readChar()) != '\u0000') {
            buf[pos++] = ch;
        }
        if (len > 0) {
            this.skipBytes(len * 2);
        }
        return new String(buf, 0, pos);
    }

    @Override
    public void readFully(byte[] b) throws IOException {
        ByteStreams.readFully(this, b);
    }

    @Override
    public void readFully(byte[] b, int off, int len) throws IOException {
        ByteStreams.readFully(this, b, off, len);
    }

    @Override
    public int skipBytes(int n) throws IOException {
        return (int)this.skip(n);
    }

    @Override
    public boolean readBoolean() throws IOException {
        return this.readUnsignedByte() != 0;
    }

    @Override
    public byte readByte() throws IOException {
        return (byte)this.readUnsignedByte();
    }

    @Override
    public int readUnsignedByte() throws IOException {
        int b = this.read();
        if (b == -1) {
            throw new EOFException();
        }
        return b;
    }

    @Override
    public short readShort() throws IOException {
        return (short)this.readUnsignedShort();
    }

    @Override
    public int readUnsignedShort() throws IOException {
        byte b1 = this.readByte();
        byte b2 = this.readByte();
        return this.mByteOrder == ByteOrder.LITTLE_ENDIAN ? Ints.fromBytes((byte)0, (byte)0, b2, b1) : Ints.fromBytes(b1, b2, (byte)0, (byte)0);
    }

    @Override
    public char readChar() throws IOException {
        return (char)this.readUnsignedShort();
    }

    @Override
    public int readInt() throws IOException {
        byte b1 = this.readByte();
        byte b2 = this.readByte();
        byte b3 = this.readByte();
        byte b4 = this.readByte();
        return this.mByteOrder == ByteOrder.LITTLE_ENDIAN ? Ints.fromBytes(b4, b3, b2, b1) : Ints.fromBytes(b1, b2, b3, b4);
    }

    @Override
    public long readLong() throws IOException {
        byte b1 = this.readByte();
        byte b2 = this.readByte();
        byte b3 = this.readByte();
        byte b4 = this.readByte();
        byte b5 = this.readByte();
        byte b6 = this.readByte();
        byte b7 = this.readByte();
        byte b8 = this.readByte();
        return this.mByteOrder == ByteOrder.LITTLE_ENDIAN ? Longs.fromBytes(b8, b7, b6, b5, b4, b3, b2, b1) : Longs.fromBytes(b1, b2, b3, b4, b5, b6, b7, b8);
    }

    @Override
    public float readFloat() throws IOException {
        return Float.intBitsToFloat(this.readInt());
    }

    @Override
    public double readDouble() throws IOException {
        return Double.longBitsToDouble(this.readLong());
    }

    @Override
    public String readLine() throws IOException {
        throw new UnsupportedOperationException();
    }

    @Override
    public String readUTF() throws IOException {
        throw new UnsupportedOperationException();
    }

    @Override
    public int read() throws IOException {
        if (this.remaining() == 0L) {
            return -1;
        }
        int b = this.in.read();
        if (b != -1) {
            ++this.mPosition;
        }
        return b;
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        int read;
        long remain = this.remaining();
        if (remain == 0L) {
            return -1;
        }
        if ((long)len > remain) {
            len = (int)remain;
        }
        if ((read = this.in.read(b, off, len)) > 0) {
            this.mPosition += (long)read;
        }
        return read;
    }

    @Override
    public long skip(long n) throws IOException {
        long skipped;
        long s;
        long remain = this.remaining();
        if (remain == 0L) {
            return 0L;
        }
        if (n > remain) {
            n = remain;
        }
        for (skipped = 0L; skipped < n && (s = this.in.skip(n - skipped)) > 0L; skipped += s) {
        }
        this.mPosition += skipped;
        return skipped;
    }

    @Override
    public int available() throws IOException {
        return (int)Math.min((long)this.in.available(), this.remaining());
    }

    @Override
    public synchronized void mark(int readlimit) {
        this.in.mark(readlimit);
        this.mMark = this.mPosition;
    }

    @Override
    public synchronized void reset() throws IOException {
        if (!this.markSupported()) {
            throw new IOException("Mark not supported");
        }
        if (this.mMark == -1L) {
            throw new IOException("Mark not set");
        }
        this.in.reset();
        this.mPosition = this.mMark;
    }
}

