/*
 * Decompiled with CFR 0.152.
 */
package brut.androlib.res;

import brut.androlib.Config;
import brut.androlib.exceptions.AndrolibException;
import brut.androlib.meta.ApkInfo;
import brut.androlib.meta.ResourcesInfo;
import brut.androlib.meta.SdkInfo;
import brut.androlib.meta.UsesFramework;
import brut.androlib.meta.VersionInfo;
import brut.androlib.res.decoder.BinaryXmlResourceParser;
import brut.androlib.res.decoder.ManifestPullEventHandler;
import brut.androlib.res.decoder.ResFileDecoder;
import brut.androlib.res.decoder.ResNinePatchStreamDecoder;
import brut.androlib.res.decoder.ResRawStreamDecoder;
import brut.androlib.res.decoder.ResStreamDecoder;
import brut.androlib.res.decoder.ResXmlPullStreamDecoder;
import brut.androlib.res.table.ResEntry;
import brut.androlib.res.table.ResEntrySpec;
import brut.androlib.res.table.ResId;
import brut.androlib.res.table.ResOverlayable;
import brut.androlib.res.table.ResPackage;
import brut.androlib.res.table.ResTable;
import brut.androlib.res.table.ResType;
import brut.androlib.res.table.ResTypeSpec;
import brut.androlib.res.table.value.ResBag;
import brut.androlib.res.table.value.ResFileReference;
import brut.androlib.res.xml.ResXmlSerializer;
import brut.androlib.res.xml.ResXmlUtils;
import brut.androlib.res.xml.ValuesXmlSerializable;
import brut.common.Log;
import brut.directory.Directory;
import brut.directory.DirectoryException;
import brut.directory.FileDirectory;
import com.google.common.collect.Lists;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.tuple.Pair;

public class ResDecoder {
    private static final String TAG = ResDecoder.class.getName();
    private final ApkInfo mApkInfo;
    private final Config mConfig;
    private final ResTable mTable;
    private final Map<String, String> mResFileMap;

    public ResDecoder(ApkInfo apkInfo, Config config) {
        this.mApkInfo = apkInfo;
        this.mConfig = config;
        this.mTable = new ResTable(apkInfo, config);
        this.mResFileMap = new HashMap<String, String>();
    }

    public ResTable getTable() {
        return this.mTable;
    }

    public Map<String, String> getResFileMap() {
        return this.mResFileMap;
    }

    public void decodeResources(File apkDir) throws AndrolibException {
        FileDirectory outDir;
        Directory inDir;
        if (!this.mApkInfo.hasResources()) {
            return;
        }
        this.mTable.load();
        HashMap<ResFileDecoder.Type, ResStreamDecoder> decoders = new HashMap<ResFileDecoder.Type, ResStreamDecoder>();
        decoders.put(ResFileDecoder.Type.UNKNOWN, new ResRawStreamDecoder());
        decoders.put(ResFileDecoder.Type.PNG_9PATCH, new ResNinePatchStreamDecoder());
        BinaryXmlResourceParser parser = new BinaryXmlResourceParser(this.mTable, this.mConfig.isIgnoreRawValues(), this.mConfig.isDecodeResolveLazy());
        ResXmlSerializer serial = new ResXmlSerializer(true);
        decoders.put(ResFileDecoder.Type.BINARY_XML, new ResXmlPullStreamDecoder(parser, serial));
        ResFileDecoder fileDecoder = new ResFileDecoder(decoders);
        try {
            inDir = this.mApkInfo.getApkFile().getDirectory();
            outDir = new FileDirectory(apkDir);
        }
        catch (DirectoryException ex) {
            throw new AndrolibException(ex);
        }
        ResPackage pkg = this.mTable.getMainPackage();
        Log.i(TAG, "Decoding value resources...");
        for (ResEntry entry : Lists.newArrayList(pkg.getGroup().listEntries())) {
            if (!(entry.getValue() instanceof ResBag)) continue;
            ((ResBag)entry.getValue()).resolveKeys();
        }
        Log.i(TAG, "Decoding file resources...");
        for (ResEntry entry : Lists.newArrayList(pkg.getGroup().listEntries())) {
            if (!(entry.getValue() instanceof ResFileReference)) continue;
            fileDecoder.decode(entry, inDir, outDir, this.mResFileMap);
        }
        serial = new ResXmlSerializer(false);
        Log.i(TAG, "Generating values XMLs...");
        this.generateValuesXmls(pkg, outDir, serial);
        this.generatePublicXml(pkg, outDir, serial);
        this.generateStagingXmls(pkg, outDir, serial);
        this.generateOverlayableXml(pkg, outDir, serial);
        AndrolibException ex = parser.getFirstError();
        if (ex != null) {
            throw ex;
        }
    }

    private void generateValuesXmls(ResPackage pkg, Directory outDir, ResXmlSerializer serial) throws AndrolibException {
        HashMap<Pair, List> entriesMap = new HashMap<Pair, List>();
        for (ResEntry resEntry : pkg.getGroup().listEntries()) {
            if (!(resEntry.getValue() instanceof ValuesXmlSerializable) || pkg.isAlias(resEntry.getResId())) continue;
            ResType type = resEntry.getType();
            Pair<String, String> key = Pair.of(type.getName(), type.getConfig().toQualifiers());
            entriesMap.computeIfAbsent(key, t -> new ArrayList()).add(resEntry);
        }
        for (Map.Entry entry : entriesMap.entrySet()) {
            Pair key = (Pair)entry.getKey();
            String typeName = (String)key.getLeft();
            String qualifiers = (String)key.getRight();
            List entries = (List)entry.getValue();
            entries.sort(Comparator.comparing(ResEntry::getResId));
            String outFileName = "res/values" + qualifiers + "/" + (typeName.endsWith("s") ? typeName : typeName + "s") + ".xml";
            try {
                OutputStream out = outDir.getFileOutput(outFileName);
                try {
                    serial.setOutput(out, null);
                    serial.startDocument(null, null);
                    serial.startTag(null, "resources");
                    for (ResEntry entry2 : entries) {
                        ((ValuesXmlSerializable)((Object)entry2.getValue())).serializeToValuesXml(serial, entry2);
                    }
                    serial.endTag(null, "resources");
                    serial.endDocument();
                    serial.flush();
                }
                finally {
                    if (out == null) continue;
                    out.close();
                }
            }
            catch (DirectoryException | IOException ex) {
                throw new AndrolibException("Could not generate: " + outFileName, ex);
            }
        }
    }

    private void generatePublicXml(ResPackage pkg, Directory outDir, ResXmlSerializer serial) throws AndrolibException {
        ArrayList<ResEntrySpec> specs = Lists.newArrayList(pkg.listEntrySpecs());
        specs.sort(Comparator.comparing(ResEntrySpec::getResId));
        String outFileName = "res/values/public.xml";
        try (OutputStream out = outDir.getFileOutput(outFileName);){
            serial.setOutput(out, null);
            serial.startDocument(null, null);
            serial.startTag(null, "resources");
            for (ResEntrySpec spec : specs) {
                serial.startTag(null, "public");
                serial.attribute(null, "type", spec.getTypeSpec().getName());
                serial.attribute(null, "name", spec.getName());
                serial.attribute(null, "id", spec.getResId().toString());
                serial.endTag(null, "public");
            }
            serial.endTag(null, "resources");
            serial.endDocument();
            serial.flush();
        }
        catch (DirectoryException | IOException ex) {
            throw new AndrolibException("Could not generate: " + outFileName, ex);
        }
    }

    private void generateStagingXmls(ResPackage pkg, Directory outDir, ResXmlSerializer serial) throws AndrolibException {
        int entryId;
        int lastEntryId;
        ResId firstId;
        ResTypeSpec typeSpec;
        OutputStream out;
        String outFileName;
        if (pkg.getGroup().getPackageCount() <= 1) {
            return;
        }
        ArrayList<ResPackage> subPkgs = Lists.newArrayList(pkg.getGroup().listSubPackages());
        ArrayList<ResEntrySpec> subSpecs = new ArrayList<ResEntrySpec>();
        for (ResPackage subPkg : subPkgs) {
            subSpecs.addAll(subPkg.listEntrySpecs());
        }
        subSpecs.sort(Comparator.comparing(ResEntrySpec::getResId));
        LinkedHashMap stagingGroups = new LinkedHashMap();
        LinkedHashMap finalGroups = new LinkedHashMap();
        LinkedHashMap prevMap = null;
        ArrayList<ResEntrySpec> currList = null;
        ResId prevId = null;
        for (ResEntrySpec spec : subSpecs) {
            LinkedHashMap currMap;
            ResId currId = spec.getResId();
            LinkedHashMap<ResTypeSpec, ArrayList<Object>> linkedHashMap = currMap = pkg.isAlias(currId) ? finalGroups : stagingGroups;
            if (prevId == null || currId.typeId() != prevId.typeId() || currMap != prevMap) {
                currList = new ArrayList<ResEntrySpec>();
                currMap.put(spec.getTypeSpec(), currList);
                prevMap = currMap;
            }
            currList.add(spec);
            prevId = currId;
        }
        if (!stagingGroups.isEmpty()) {
            outFileName = "res/values/public-staging.xml";
            try {
                out = outDir.getFileOutput(outFileName);
                try {
                    serial.setOutput(out, null);
                    serial.startDocument(null, null);
                    serial.startTag(null, "resources");
                    for (Map.Entry mapEntry : stagingGroups.entrySet()) {
                        typeSpec = (ResTypeSpec)mapEntry.getKey();
                        firstId = ResId.of(typeSpec.getPackage().getId(), typeSpec.getId(), 0);
                        serial.startTag(null, "staging-public-group");
                        serial.attribute(null, "type", ((ResTypeSpec)mapEntry.getKey()).getName());
                        serial.attribute(null, "first-id", firstId.toString());
                        lastEntryId = 0;
                        for (ResEntrySpec spec : (List)mapEntry.getValue()) {
                            entryId = spec.getId();
                            while (lastEntryId++ < entryId) {
                                serial.startTag(null, "public");
                                serial.attribute(null, "name", "removed_");
                                serial.endTag(null, "public");
                            }
                            serial.startTag(null, "public");
                            serial.attribute(null, "name", spec.getName());
                            serial.endTag(null, "public");
                        }
                        serial.endTag(null, "staging-public-group");
                    }
                    serial.endTag(null, "resources");
                    serial.endDocument();
                    serial.flush();
                }
                finally {
                    if (out != null) {
                        out.close();
                    }
                }
            }
            catch (DirectoryException | IOException ex) {
                throw new AndrolibException("Could not generate: " + outFileName, ex);
            }
        }
        if (!finalGroups.isEmpty()) {
            outFileName = "res/values/public-final.xml";
            try {
                out = outDir.getFileOutput(outFileName);
                try {
                    serial.setOutput(out, null);
                    serial.startDocument(null, null);
                    serial.startTag(null, "resources");
                    for (Map.Entry mapEntry : finalGroups.entrySet()) {
                        typeSpec = (ResTypeSpec)mapEntry.getKey();
                        firstId = ResId.of(typeSpec.getPackage().getId(), typeSpec.getId(), 0);
                        serial.startTag(null, "staging-public-group-final");
                        serial.attribute(null, "type", ((ResTypeSpec)mapEntry.getKey()).getName());
                        serial.attribute(null, "first-id", firstId.toString());
                        lastEntryId = 0;
                        for (ResEntrySpec spec : (List)mapEntry.getValue()) {
                            entryId = spec.getId();
                            while (lastEntryId++ < entryId) {
                                serial.startTag(null, "public");
                                serial.attribute(null, "name", "removed_");
                                serial.endTag(null, "public");
                            }
                            serial.startTag(null, "public");
                            serial.attribute(null, "name", spec.getName());
                            serial.endTag(null, "public");
                        }
                        serial.endTag(null, "staging-public-group-final");
                    }
                    serial.endTag(null, "resources");
                    serial.endDocument();
                    serial.flush();
                }
                finally {
                    if (out != null) {
                        out.close();
                    }
                }
            }
            catch (DirectoryException | IOException ex) {
                throw new AndrolibException("Could not generate: " + outFileName, ex);
            }
        }
    }

    private void generateOverlayableXml(ResPackage pkg, Directory outDir, ResXmlSerializer serial) throws AndrolibException {
        if (pkg.getOverlayableCount() == 0) {
            return;
        }
        ArrayList<ResOverlayable> overlayables = Lists.newArrayList(pkg.listOverlayables());
        overlayables.sort(Comparator.comparing(ResOverlayable::getName));
        String outFileName = "res/values/overlayable.xml";
        try (OutputStream out = outDir.getFileOutput(outFileName);){
            serial.setOutput(out, null);
            serial.startDocument(null, null);
            serial.startTag(null, "resources");
            for (ResOverlayable overlayable : overlayables) {
                overlayable.serializeToXml(serial);
            }
            serial.endTag(null, "resources");
            serial.endDocument();
            serial.flush();
        }
        catch (DirectoryException | IOException ex) {
            throw new AndrolibException("Could not generate: " + outFileName, ex);
        }
    }

    public void decodeManifest(File apkDir) throws AndrolibException {
        String[] flags;
        if (!this.mApkInfo.hasManifest()) {
            return;
        }
        BinaryXmlResourceParser parser = new BinaryXmlResourceParser(this.mTable, this.mConfig.isIgnoreRawValues(), this.mConfig.isDecodeResolveLazy());
        ResXmlSerializer serial = new ResXmlSerializer(true);
        ManifestPullEventHandler handler = new ManifestPullEventHandler(this.mApkInfo, !this.mConfig.isAnalysisMode());
        ResXmlPullStreamDecoder decoder = new ResXmlPullStreamDecoder(parser, serial, handler);
        ResPackage pkg = this.mTable.getMainPackage();
        try {
            Directory inDir = this.mApkInfo.getApkFile().getDirectory();
            FileDirectory outDir = new FileDirectory(apkDir);
            Log.i(TAG, "Decoding AndroidManifest.xml with " + (pkg != null ? "resources" : "only framework resources") + "...");
            try (InputStream in = inDir.getFileInput("AndroidManifest.xml");
                 OutputStream out = outDir.getFileOutput("AndroidManifest.xml");){
                decoder.decode(in, out);
            }
        }
        catch (DirectoryException | IOException ex) {
            throw new AndrolibException(ex);
        }
        ResourcesInfo resourcesInfo = this.mApkInfo.getResourcesInfo();
        if (parser.hasRawValues() && !this.mConfig.isIgnoreRawValues()) {
            resourcesInfo.setKeepRawValues(true);
        }
        if (pkg != null) {
            ArrayList<Integer> libPackageIds;
            int id;
            Iterator iterator;
            ArrayList<Integer> framePackageIds;
            String versionName;
            VersionInfo versionInfo;
            String refValue;
            resourcesInfo.setPackageId(pkg.getId());
            String manifestPackage = resourcesInfo.getPackageName();
            String resourcesPackage = pkg.getName();
            if (resourcesPackage != null && !resourcesPackage.equals(manifestPackage)) {
                resourcesInfo.setPackageName(resourcesPackage);
            } else {
                resourcesInfo.setPackageName(null);
            }
            SdkInfo sdkInfo = this.mApkInfo.getSdkInfo();
            if (!sdkInfo.isEmpty()) {
                String refValue2;
                String maxSdkVersion;
                String targetSdkVersion;
                String refValue3;
                String minSdkVersion = sdkInfo.getMinSdkVersion();
                if (minSdkVersion != null && (refValue3 = ResXmlUtils.pullValueFromIntegers(apkDir, minSdkVersion)) != null) {
                    sdkInfo.setMinSdkVersion(refValue3);
                }
                if ((targetSdkVersion = sdkInfo.getTargetSdkVersion()) != null && (refValue = ResXmlUtils.pullValueFromIntegers(apkDir, targetSdkVersion)) != null) {
                    sdkInfo.setTargetSdkVersion(refValue);
                }
                if ((maxSdkVersion = sdkInfo.getMaxSdkVersion()) != null && (refValue2 = ResXmlUtils.pullValueFromIntegers(apkDir, maxSdkVersion)) != null) {
                    sdkInfo.setMaxSdkVersion(refValue2);
                }
            }
            if (!(versionInfo = this.mApkInfo.getVersionInfo()).isEmpty() && (versionName = versionInfo.getVersionName()) != null && (refValue = ResXmlUtils.pullValueFromStrings(apkDir, versionName)) != null) {
                versionInfo.setVersionName(refValue);
            }
            if (!(framePackageIds = Lists.newArrayList(this.mTable.getFramePackageIds())).isEmpty()) {
                UsesFramework usesFramework = this.mApkInfo.getUsesFramework();
                List<Integer> frameworkIds = usesFramework.getIds();
                framePackageIds.sort(null);
                iterator = framePackageIds.iterator();
                while (iterator.hasNext()) {
                    id = (Integer)iterator.next();
                    frameworkIds.add(id);
                }
                usesFramework.setTag(this.mConfig.getFrameworkTag());
            }
            if (!(libPackageIds = Lists.newArrayList(this.mTable.getLibPackageIds())).isEmpty()) {
                List<String> usesLibrary = this.mApkInfo.getUsesLibrary();
                libPackageIds.sort(null);
                iterator = libPackageIds.iterator();
                while (iterator.hasNext()) {
                    id = (Integer)iterator.next();
                    usesLibrary.add(this.mTable.getDynamicRefPackageName(id));
                }
            }
        } else {
            resourcesInfo.setPackageName(null);
        }
        File manifest = new File(apkDir, "AndroidManifest.xml");
        if (!this.mConfig.isAnalysisMode()) {
            ResXmlUtils.removeManifestVersions(manifest);
        }
        if ((flags = ResXmlUtils.pullManifestFeatureFlags(manifest)) != null) {
            Map<String, Boolean> featureFlags = this.mApkInfo.getFeatureFlags();
            for (String flag : flags) {
                boolean value;
                if (flag.startsWith("!")) {
                    flag = flag.substring(1);
                    value = false;
                } else {
                    value = true;
                }
                featureFlags.put(flag, value);
            }
        }
    }
}

