/*
 * Decompiled with CFR 0.152.
 */
package brut.androlib.res.table;

import brut.androlib.res.table.ResPackage;
import java.util.Objects;

public class ResTypeSpec {
    private final ResPackage mPackage;
    private final int mId;
    private final String mName;

    public ResTypeSpec(ResPackage pkg, int id, String name) {
        assert (pkg != null && id > 0 && name != null);
        this.mPackage = pkg;
        this.mId = id;
        this.mName = name;
    }

    public ResPackage getPackage() {
        return this.mPackage;
    }

    public int getId() {
        return this.mId;
    }

    public String getName() {
        return this.mName;
    }

    public boolean isBagType() {
        switch (this.mName) {
            case "attr": 
            case "^attr-private": 
            case "array": 
            case "plurals": 
            case "style": {
                return true;
            }
        }
        return false;
    }

    public String toString() {
        return String.format("ResTypeSpec{pkg=%s, id=0x%02x, name=%s}", this.mPackage, this.mId, this.mName);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof ResTypeSpec) {
            ResTypeSpec other = (ResTypeSpec)obj;
            return this.mPackage.equals(other.mPackage) && this.mId == other.mId && this.mName.equals(other.mName);
        }
        return false;
    }

    public int hashCode() {
        return Objects.hash(this.mPackage, this.mId, this.mName);
    }
}

