/*
 * Decompiled with CFR 0.152.
 */
package brut.androlib.res.decoder;

import brut.androlib.exceptions.AndrolibException;
import brut.androlib.exceptions.NinePatchNotFoundException;
import brut.androlib.exceptions.RawXmlEncounteredException;
import brut.androlib.res.decoder.ResStreamDecoder;
import brut.androlib.res.table.ResEntry;
import brut.androlib.res.table.value.ResFileReference;
import brut.androlib.res.table.value.ResPrimitive;
import brut.androlib.res.table.value.ResString;
import brut.common.Log;
import brut.directory.Directory;
import brut.directory.DirectoryException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Map;
import org.apache.commons.io.FilenameUtils;

public class ResFileDecoder {
    private static final String TAG = ResFileDecoder.class.getName();
    private final Map<Type, ResStreamDecoder> mDecoders;

    public ResFileDecoder(Map<Type, ResStreamDecoder> decoders) {
        this.mDecoders = decoders;
    }

    public void decode(ResEntry entry, Directory inDir, Directory outDir, Map<String, String> resFileMap) {
        String inFileName = ((ResFileReference)entry.getValue()).getPath();
        if (!inDir.containsFile(inFileName)) {
            entry.setValue(new ResString(inFileName));
            return;
        }
        String ext = inFileName.endsWith(".9.png") ? "9.png" : FilenameUtils.getExtension(inFileName).toLowerCase();
        Type type = Type.UNKNOWN;
        if (!ext.isEmpty() && !entry.getType().getName().equals("raw")) {
            switch (ext) {
                case "xml": 
                case "xsd": {
                    type = Type.BINARY_XML;
                    break;
                }
                case "9.png": {
                    type = Type.PNG_9PATCH;
                }
            }
        }
        String outFileName = "res/" + entry.getType().getName() + entry.getType().getConfig().toQualifiers() + "/" + entry.getName() + (ext.isEmpty() ? "" : "." + ext);
        resFileMap.put(inFileName, outFileName);
        Log.d(TAG, "Decoding file " + inFileName + " to " + outFileName);
        try {
            if (type != Type.UNKNOWN) {
                try {
                    this.decode(type, inDir, inFileName, outDir, outFileName);
                    return;
                }
                catch (RawXmlEncounteredException ignored) {
                    Log.d(TAG, "Could not decode binary XML file: " + inFileName);
                }
                catch (NinePatchNotFoundException ignored) {
                    Log.d(TAG, "Could not find 9-patch chunk in file: " + inFileName);
                }
            }
            this.decode(Type.UNKNOWN, inDir, inFileName, outDir, outFileName);
        }
        catch (AndrolibException ignored) {
            Log.w(TAG, "Could not decode file, replacing by NULL value: " + inFileName);
            entry.setValue(ResPrimitive.NULL);
        }
    }

    private void decode(Type type, Directory inDir, String inFileName, Directory outDir, String outFileName) throws AndrolibException {
        ResStreamDecoder decoder = this.mDecoders.get((Object)type);
        if (decoder == null) {
            throw new AndrolibException("Undefined decoder for type: " + (Object)((Object)type));
        }
        boolean success = false;
        try (InputStream in = inDir.getFileInput(inFileName);
             OutputStream out = outDir.getFileOutput(outFileName);){
            decoder.decode(in, out);
            success = true;
        }
        catch (DirectoryException | IOException ex) {
            throw new AndrolibException(ex);
        }
        finally {
            if (!success) {
                outDir.removeFile(outFileName);
            }
        }
    }

    public static enum Type {
        UNKNOWN,
        BINARY_XML,
        PNG_9PATCH;

    }
}

