/*
 * Decompiled with CFR 0.152.
 */
package brut.androlib.res;

import brut.androlib.Config;
import brut.androlib.exceptions.AndrolibException;
import brut.androlib.exceptions.FrameworkNotFoundException;
import brut.androlib.meta.ApkInfo;
import brut.androlib.res.decoder.BinaryResourceParser;
import brut.androlib.res.table.ResTable;
import brut.common.Log;
import brut.util.BrutIO;
import brut.util.OS;
import brut.util.OSDetection;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.List;
import java.util.zip.CRC32;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import java.util.zip.ZipOutputStream;
import org.apache.commons.lang3.tuple.Pair;

public class Framework {
    private static final String TAG;
    private static final File DEFAULT_DIRECTORY;
    private final Config mConfig;
    private File mDirectory;

    public Framework(Config config) {
        this.mConfig = config;
    }

    public void install(File apkFile) throws AndrolibException {
        try (ZipFile zip = new ZipFile(apkFile);){
            ZipEntry entry = zip.getEntry("resources.arsc");
            if (entry == null) {
                throw new AndrolibException("Could not find resources.arsc in file: " + apkFile);
            }
            byte[] data = BrutIO.readAndClose(zip.getInputStream(entry));
            ResTable table = this.parseAndPublicizeResources(data);
            int pkgId = table.listPackageGroups().iterator().next().getId();
            File outFile = new File(this.getDirectory(), pkgId + this.getApkSuffix());
            try (ZipOutputStream out = new ZipOutputStream(Files.newOutputStream(outFile.toPath(), new OpenOption[0]));){
                out.setMethod(0);
                CRC32 crc = new CRC32();
                crc.update(data);
                entry = new ZipEntry("resources.arsc");
                entry.setSize(data.length);
                entry.setMethod(0);
                entry.setCrc(crc.getValue());
                out.putNextEntry(entry);
                out.write(data);
                out.closeEntry();
                entry = zip.getEntry("AndroidManifest.xml");
                if (entry != null) {
                    byte[] manifest = BrutIO.readAndClose(zip.getInputStream(entry));
                    CRC32 manifestCrc = new CRC32();
                    manifestCrc.update(manifest);
                    entry.setSize(manifest.length);
                    entry.setCompressedSize(-1L);
                    entry.setCrc(manifestCrc.getValue());
                    out.putNextEntry(entry);
                    out.write(manifest);
                    out.closeEntry();
                }
            }
            Log.i(TAG, "Framework installed to: " + outFile);
        }
        catch (IOException ex) {
            throw new AndrolibException(ex);
        }
    }

    private ResTable parseAndPublicizeResources(byte[] data) throws AndrolibException {
        ResTable table = new ResTable(new ApkInfo(), this.mConfig);
        BinaryResourceParser parser = new BinaryResourceParser(table, true, true);
        parser.enableCollectFlagsOffsets();
        parser.parse(new ByteArrayInputStream(data));
        if (table.getPackageGroupCount() == 0) {
            throw new AndrolibException("No packages in resources.arsc in file.");
        }
        ByteBuffer buffer = ByteBuffer.wrap(data).order(ByteOrder.LITTLE_ENDIAN);
        for (Pair<Long, Integer> pair : parser.getEntrySpecFlagsOffsets()) {
            int position = pair.getKey().intValue();
            int count = pair.getValue();
            int i = 0;
            while (i < count) {
                int flags = buffer.getInt(position);
                buffer.putInt(position, flags | 0x40000000);
                ++i;
                position += 4;
            }
        }
        return table;
    }

    public File getDirectory() throws AndrolibException {
        if (this.mDirectory == null) {
            File dir;
            String path = this.mConfig.getFrameworkDirectory();
            File file = dir = path != null && !path.isEmpty() ? new File(path) : DEFAULT_DIRECTORY;
            if (dir.exists() && !dir.isDirectory()) {
                throw new AndrolibException("Framework path is not a directory: " + dir);
            }
            File parent = dir.getParentFile();
            if (parent != null && parent.exists() && !parent.isDirectory()) {
                throw new AndrolibException("Framework path's parent is not a directory: " + parent);
            }
            if (!dir.exists() && !dir.mkdirs()) {
                throw new AndrolibException("Could not create framework directory: " + dir);
            }
            this.mDirectory = dir;
        }
        return this.mDirectory;
    }

    public File getApkFile(int id) throws AndrolibException {
        return this.getApkFile(id, this.mConfig.getFrameworkTag());
    }

    public File getApkFile(int id, String tag) throws AndrolibException {
        File dir = this.getDirectory();
        File apkFile = new File(dir, id + Framework.getApkSuffix(tag));
        if (apkFile.exists()) {
            return apkFile;
        }
        apkFile = new File(dir, id + Framework.getApkSuffix(null));
        if (apkFile.exists()) {
            return apkFile;
        }
        if (id == 1) {
            try {
                BrutIO.copyAndClose(this.getAndroidFrameworkAsStream(), Files.newOutputStream(apkFile.toPath(), new OpenOption[0]));
            }
            catch (IOException ex) {
                throw new AndrolibException(ex);
            }
            return apkFile;
        }
        throw new FrameworkNotFoundException(id);
    }

    private String getApkSuffix() {
        return Framework.getApkSuffix(this.mConfig.getFrameworkTag());
    }

    private static String getApkSuffix(String tag) {
        return (tag != null && !tag.isEmpty() ? "-" + tag : "") + ".apk";
    }

    private InputStream getAndroidFrameworkAsStream() {
        return this.getClass().getResourceAsStream("/prebuilt/android-framework.jar");
    }

    public void cleanDirectory() throws AndrolibException {
        for (File apkFile : this.listDirectory()) {
            Log.i(TAG, "Removing framework file: " + apkFile.getName());
            OS.rmfile(apkFile);
        }
    }

    public List<File> listDirectory() throws AndrolibException {
        boolean ignoreTag = this.mConfig.isForced();
        String suffix = ignoreTag ? Framework.getApkSuffix(null) : this.getApkSuffix();
        ArrayList<File> apkFiles = new ArrayList<File>();
        for (File file : this.getDirectory().listFiles()) {
            if (!file.isFile() || !Framework.isValidApkName(file.getName(), suffix, ignoreTag)) continue;
            apkFiles.add(file);
        }
        return apkFiles;
    }

    private static boolean isValidApkName(String fileName, String suffix, boolean ignoreTag) {
        if (!fileName.endsWith(suffix)) {
            return false;
        }
        if (ignoreTag) {
            return true;
        }
        int len = fileName.length() - suffix.length();
        if (len == 0) {
            return false;
        }
        for (int i = 0; i < len; ++i) {
            char ch = fileName.charAt(i);
            if (ch >= '0' && ch <= '9') continue;
            return false;
        }
        return true;
    }

    public void publicizeResources(File arscFile) throws AndrolibException {
        try {
            byte[] data = Files.readAllBytes(arscFile.toPath());
            this.parseAndPublicizeResources(data);
            Files.write(arscFile.toPath(), data, new OpenOption[0]);
        }
        catch (IOException ex) {
            throw new AndrolibException(ex);
        }
    }

    static {
        String xdgDataHome;
        TAG = Framework.class.getName();
        String userHome = System.getProperty("user.home");
        Path defDir = OSDetection.isMacOSX() ? Paths.get(userHome, "Library", "apktool", "framework") : (OSDetection.isWindows() ? Paths.get(userHome, "AppData", "Local", "apktool", "framework") : ((xdgDataHome = System.getenv("XDG_DATA_HOME")) != null ? Paths.get(xdgDataHome, "apktool", "framework") : Paths.get(userHome, ".local", "share", "apktool", "framework")));
        DEFAULT_DIRECTORY = defDir.toFile();
    }
}

