/*
 * Decompiled with CFR 0.152.
 */
package brut.yaml;

import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import org.apache.commons.text.StringEscapeUtils;
import org.apache.commons.text.translate.CharSequenceTranslator;

public final class YamlStringEscapeUtils {
    private YamlStringEscapeUtils() {
    }

    public static String escapeString(String str) {
        return YamlStringEscapeUtils.escapeJavaStyleString(str);
    }

    private static String escapeJavaStyleString(String str) {
        if (str == null) {
            return null;
        }
        try {
            StringWriter writer = new StringWriter(str.length() * 2);
            YamlStringEscapeUtils.escapeJavaStyleString(writer, str);
            return writer.toString();
        }
        catch (IOException ioe) {
            throw new RuntimeException(ioe);
        }
    }

    private static void escapeJavaStyleString(Writer writer, String str) throws IOException {
        if (writer == null) {
            throw new IllegalArgumentException("The Writer must not be null");
        }
        if (str == null) {
            return;
        }
        int sz = str.length();
        block11: for (int i = 0; i < sz; ++i) {
            char ch = str.charAt(i);
            if (ch > '\ufffd') {
                writer.write("\\u" + CharSequenceTranslator.hex(ch));
                continue;
            }
            if (ch > '\ud7ff' && ch < '\ue000') {
                writer.write("\\u" + CharSequenceTranslator.hex(ch));
                continue;
            }
            if (ch > '~' && ch != '\u0085' && ch < '\u00a0') {
                writer.write("\\u00" + CharSequenceTranslator.hex(ch));
                continue;
            }
            if (ch < ' ') {
                switch (ch) {
                    case '\t': {
                        writer.write(92);
                        writer.write(116);
                        break;
                    }
                    case '\n': {
                        writer.write(92);
                        writer.write(110);
                        break;
                    }
                    case '\r': {
                        writer.write(92);
                        writer.write(114);
                        break;
                    }
                    default: {
                        if (ch > '\u000f') {
                            writer.write("\\u00" + CharSequenceTranslator.hex(ch));
                            break;
                        }
                        writer.write("\\u000" + CharSequenceTranslator.hex(ch));
                        break;
                    }
                }
                continue;
            }
            switch (ch) {
                case '\'': {
                    writer.write(39);
                    continue block11;
                }
                case '\"': {
                    writer.write(92);
                    writer.write(34);
                    continue block11;
                }
                case '\\': {
                    writer.write(92);
                    writer.write(92);
                    continue block11;
                }
                case '/': {
                    writer.write(47);
                    continue block11;
                }
                default: {
                    writer.write(ch);
                }
            }
        }
    }

    public static String unescapeString(String str) {
        return StringEscapeUtils.unescapeJava(str);
    }
}

