/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.smali.util;

import java.io.IOException;
import java.io.Writer;

public class IndentingWriter
extends Writer {
    protected final Writer writer;
    protected final char[] buffer = new char[24];
    protected int indentLevel = 0;
    private boolean beginningOfLine = true;
    private static final String newLine = System.getProperty("line.separator");

    public IndentingWriter(Writer writer) {
        this.writer = writer;
    }

    protected void writeIndent() throws IOException {
        for (int i = 0; i < this.indentLevel; ++i) {
            this.writer.write(32);
        }
    }

    @Override
    public void write(int chr) throws IOException {
        if (chr == 10) {
            this.writer.write(newLine);
            this.beginningOfLine = true;
        } else {
            if (this.beginningOfLine) {
                this.writeIndent();
            }
            this.beginningOfLine = false;
            this.writer.write(chr);
        }
    }

    private void writeLine(char[] chars, int start, int len) throws IOException {
        if (this.beginningOfLine && len > 0) {
            this.writeIndent();
            this.beginningOfLine = false;
        }
        this.writer.write(chars, start, len);
    }

    private void writeLine(String str, int start, int len) throws IOException {
        if (this.beginningOfLine && len > 0) {
            this.writeIndent();
            this.beginningOfLine = false;
        }
        this.writer.write(str, start, len);
    }

    @Override
    public void write(char[] chars) throws IOException {
        this.write(chars, 0, chars.length);
    }

    @Override
    public void write(char[] chars, int start, int len) throws IOException {
        int end = start + len;
        int pos = start;
        while (pos < end) {
            if (chars[pos] == '\n') {
                this.writeLine(chars, start, pos - start);
                this.writer.write(newLine);
                this.beginningOfLine = true;
                start = ++pos;
                continue;
            }
            ++pos;
        }
        this.writeLine(chars, start, pos - start);
    }

    @Override
    public void write(String s) throws IOException {
        this.write(s, 0, s.length());
    }

    @Override
    public void write(String str, int start, int len) throws IOException {
        int end = start + len;
        int pos = start;
        while (pos < end) {
            pos = str.indexOf(10, start);
            if (pos == -1 || pos >= end) {
                this.writeLine(str, start, end - start);
                return;
            }
            this.writeLine(str, start, pos - start);
            this.writer.write(newLine);
            this.beginningOfLine = true;
            start = pos + 1;
        }
    }

    @Override
    public Writer append(CharSequence charSequence) throws IOException {
        this.write(charSequence.toString());
        return this;
    }

    @Override
    public Writer append(CharSequence charSequence, int start, int len) throws IOException {
        this.write(charSequence.subSequence(start, len).toString());
        return this;
    }

    @Override
    public Writer append(char c) throws IOException {
        this.write(c);
        return this;
    }

    @Override
    public void flush() throws IOException {
        this.writer.flush();
    }

    @Override
    public void close() throws IOException {
        this.writer.close();
    }

    public void indent(int indentAmount) {
        this.indentLevel += indentAmount;
        if (this.indentLevel < 0) {
            this.indentLevel = 0;
        }
    }

    public void deindent(int indentAmount) {
        this.indentLevel -= indentAmount;
        if (this.indentLevel < 0) {
            this.indentLevel = 0;
        }
    }
}

