/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.smali.util;

import java.io.IOException;
import java.io.InputStream;
import java.io.RandomAccessFile;
import javax.annotation.Nonnull;

public class RandomAccessFileInputStream
extends InputStream {
    private int filePosition;
    @Nonnull
    private final RandomAccessFile raf;

    public RandomAccessFileInputStream(@Nonnull RandomAccessFile raf, int filePosition) {
        this.filePosition = filePosition;
        this.raf = raf;
    }

    @Override
    public int read() throws IOException {
        this.raf.seek(this.filePosition);
        ++this.filePosition;
        return this.raf.read();
    }

    @Override
    public int read(byte[] bytes) throws IOException {
        this.raf.seek(this.filePosition);
        int bytesRead = this.raf.read(bytes);
        this.filePosition += bytesRead;
        return bytesRead;
    }

    @Override
    public int read(byte[] bytes, int offset, int length) throws IOException {
        this.raf.seek(this.filePosition);
        int bytesRead = this.raf.read(bytes, offset, length);
        this.filePosition += bytesRead;
        return bytesRead;
    }

    @Override
    public long skip(long l) throws IOException {
        int skipBytes = Math.min((int)l, this.available());
        this.filePosition += skipBytes;
        return skipBytes;
    }

    @Override
    public int available() throws IOException {
        return (int)this.raf.length() - this.filePosition;
    }

    @Override
    public boolean markSupported() {
        return false;
    }
}

