/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.smali.dexlib2.dexbacked.reference;

import com.android.tools.smali.dexlib2.base.reference.BaseMethodProtoReference;
import com.android.tools.smali.dexlib2.dexbacked.DexBackedDexFile;
import com.android.tools.smali.dexlib2.dexbacked.util.FixedSizeList;
import com.android.tools.smali.dexlib2.iface.reference.Reference;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nonnull;

public class DexBackedMethodProtoReference
extends BaseMethodProtoReference {
    @Nonnull
    public final DexBackedDexFile dexFile;
    private final int protoIndex;

    public DexBackedMethodProtoReference(@Nonnull DexBackedDexFile dexFile, int protoIndex) {
        this.dexFile = dexFile;
        this.protoIndex = protoIndex;
    }

    @Nonnull
    public List<String> getParameterTypes() {
        int parametersOffset = this.dexFile.getBuffer().readSmallUint(this.dexFile.getProtoSection().getOffset(this.protoIndex) + 8);
        if (parametersOffset > 0) {
            final int parameterCount = this.dexFile.getDataBuffer().readSmallUint(parametersOffset + 0);
            final int paramListStart = parametersOffset + 4;
            return new FixedSizeList<String>(){

                @Override
                @Nonnull
                public String readItem(int index) {
                    return (String)DexBackedMethodProtoReference.this.dexFile.getTypeSection().get(DexBackedMethodProtoReference.this.dexFile.getDataBuffer().readUshort(paramListStart + 2 * index));
                }

                @Override
                public int size() {
                    return parameterCount;
                }
            };
        }
        return Collections.emptyList();
    }

    @Override
    @Nonnull
    public String getReturnType() {
        return (String)this.dexFile.getTypeSection().get(this.dexFile.getBuffer().readSmallUint(this.dexFile.getProtoSection().getOffset(this.protoIndex) + 4));
    }

    public int getSize() {
        int size = 12;
        List<String> parameters = this.getParameterTypes();
        if (!parameters.isEmpty()) {
            size += 4 + parameters.size() * 2;
        }
        return size;
    }

    @Override
    public void validateReference() throws Reference.InvalidReferenceException {
        if (this.protoIndex < 0 || this.protoIndex >= this.dexFile.getProtoSection().size()) {
            throw new Reference.InvalidReferenceException("proto@" + this.protoIndex);
        }
    }
}

