/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.data.osm;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.locks.Lock;
import java.util.function.Predicate;
import org.openstreetmap.josm.data.Data;
import org.openstreetmap.josm.data.DataSource;
import org.openstreetmap.josm.data.ProjectionBounds;
import org.openstreetmap.josm.data.osm.BBox;
import org.openstreetmap.josm.data.osm.DataSelectionListener;
import org.openstreetmap.josm.data.osm.DownloadPolicy;
import org.openstreetmap.josm.data.osm.HighlightUpdateListener;
import org.openstreetmap.josm.data.osm.INode;
import org.openstreetmap.josm.data.osm.IPrimitive;
import org.openstreetmap.josm.data.osm.IRelation;
import org.openstreetmap.josm.data.osm.IWay;
import org.openstreetmap.josm.data.osm.Lockable;
import org.openstreetmap.josm.data.osm.OsmPrimitiveType;
import org.openstreetmap.josm.data.osm.PrimitiveId;
import org.openstreetmap.josm.data.osm.SimplePrimitiveId;
import org.openstreetmap.josm.data.osm.UploadPolicy;
import org.openstreetmap.josm.data.osm.WaySegment;
import org.openstreetmap.josm.data.osm.visitor.BoundingXYVisitor;
import org.openstreetmap.josm.tools.SubclassFilteredCollection;

public interface OsmData<O extends IPrimitive, N extends INode, W extends IWay<N>, R extends IRelation<?>>
extends Data,
Lockable {
    public String getVersion();

    public String getName();

    public void setName(String var1);

    public void addPrimitive(O var1);

    public void clear();

    public List<N> searchNodes(BBox var1);

    public boolean containsNode(N var1);

    public List<W> searchWays(BBox var1);

    public boolean containsWay(W var1);

    public List<R> searchRelations(BBox var1);

    public boolean containsRelation(R var1);

    default public O getPrimitiveById(long id, OsmPrimitiveType type) {
        return this.getPrimitiveById(new SimplePrimitiveId(id, type));
    }

    public O getPrimitiveById(PrimitiveId var1);

    public <T extends O> Collection<T> getPrimitives(Predicate<? super O> var1);

    public Collection<N> getNodes();

    public Collection<W> getWays();

    public Collection<R> getRelations();

    default public Collection<O> allPrimitives() {
        return this.getPrimitives(o -> true);
    }

    default public Collection<O> allNonDeletedPrimitives() {
        return this.getPrimitives(p -> !p.isDeleted());
    }

    default public Collection<O> allNonDeletedCompletePrimitives() {
        return this.getPrimitives(primitive -> !primitive.isDeleted() && !primitive.isIncomplete());
    }

    default public Collection<O> allNonDeletedPhysicalPrimitives() {
        return this.getPrimitives(primitive -> !primitive.isDeleted() && !primitive.isIncomplete() && !(primitive instanceof IRelation));
    }

    default public Collection<O> allModifiedPrimitives() {
        return this.getPrimitives(IPrimitive::isModified);
    }

    default public Collection<O> allPreservedPrimitives() {
        return this.getPrimitives(IPrimitive::isPreserved);
    }

    public DownloadPolicy getDownloadPolicy();

    public void setDownloadPolicy(DownloadPolicy var1);

    public UploadPolicy getUploadPolicy();

    public void setUploadPolicy(UploadPolicy var1);

    public Lock getReadLock();

    public Collection<WaySegment> getHighlightedVirtualNodes();

    public Collection<WaySegment> getHighlightedWaySegments();

    default public void clearHighlightedVirtualNodes() {
        this.setHighlightedVirtualNodes(new ArrayList<WaySegment>());
    }

    default public void clearHighlightedWaySegments() {
        this.setHighlightedWaySegments(new ArrayList<WaySegment>());
    }

    public void setHighlightedVirtualNodes(Collection<WaySegment> var1);

    public void setHighlightedWaySegments(Collection<WaySegment> var1);

    public void addHighlightUpdateListener(HighlightUpdateListener var1);

    public void removeHighlightUpdateListener(HighlightUpdateListener var1);

    default public Collection<O> getSelected() {
        return new SubclassFilteredCollection(this.getAllSelected(), p -> !p.isDeleted());
    }

    public Collection<O> getAllSelected();

    default public Collection<N> getSelectedNodes() {
        return new SubclassFilteredCollection(this.getSelected(), INode.class::isInstance);
    }

    default public Collection<W> getSelectedWays() {
        return new SubclassFilteredCollection(this.getSelected(), IWay.class::isInstance);
    }

    default public Collection<R> getSelectedRelations() {
        return new SubclassFilteredCollection(this.getSelected(), IRelation.class::isInstance);
    }

    public boolean selectionEmpty();

    public boolean isSelected(O var1);

    public void toggleSelected(Collection<? extends PrimitiveId> var1);

    public void toggleSelected(PrimitiveId ... var1);

    public void setSelected(Collection<? extends PrimitiveId> var1);

    public void setSelected(PrimitiveId ... var1);

    public void addSelected(Collection<? extends PrimitiveId> var1);

    public void addSelected(PrimitiveId ... var1);

    public void clearSelection(PrimitiveId ... var1);

    public void clearSelection(Collection<? extends PrimitiveId> var1);

    public void clearSelection();

    public void addSelectionListener(DataSelectionListener var1);

    public void removeSelectionListener(DataSelectionListener var1);

    default public ProjectionBounds getDataSourceBoundingBox() {
        BoundingXYVisitor bbox = new BoundingXYVisitor();
        for (DataSource source : this.getDataSources()) {
            bbox.visit(source.bounds);
        }
        if (bbox.hasExtend()) {
            return bbox.getBounds();
        }
        return null;
    }

    public void clearMappaintCache();

    default public boolean isModified() {
        return false;
    }
}

