/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.dialogs.properties;

import java.awt.event.ActionEvent;
import java.util.Map;
import java.util.Objects;
import java.util.function.IntFunction;
import java.util.function.Supplier;
import javax.swing.JTable;
import org.openstreetmap.josm.data.osm.Tag;
import org.openstreetmap.josm.gui.MainApplication;
import org.openstreetmap.josm.gui.dialogs.properties.HelpAction;
import org.openstreetmap.josm.tools.I18n;

public class HelpTagAction
extends HelpAction {
    private final Supplier<Tag> tagSupplier;

    public HelpTagAction(Supplier<Tag> tagSupplier) {
        this.tagSupplier = Objects.requireNonNull(tagSupplier);
        this.putValue("Name", I18n.tr("Go to OSM wiki for tag help", new Object[0]));
    }

    public HelpTagAction(JTable tagTable, IntFunction<String> tagKeySupplier, IntFunction<Map<String, Integer>> tagValuesSupplier) {
        this.tagSupplier = () -> {
            if (tagTable.getSelectedRowCount() == 1) {
                int row = tagTable.getSelectedRow();
                String key = (String)tagKeySupplier.apply(row);
                Map m = (Map)tagValuesSupplier.apply(row);
                if (!m.isEmpty()) {
                    String val = (String)m.entrySet().iterator().next().getKey();
                    return new Tag(key, val);
                }
            }
            return null;
        };
        this.putValue("Name", I18n.tr("Go to OSM wiki for tag help", new Object[0]));
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        Tag tag = this.tagSupplier.get();
        if (tag != null) {
            MainApplication.worker.execute(() -> HelpTagAction.displayTagHelp(tag.getKey(), tag.getValue()));
        } else {
            super.actionPerformed(e);
        }
    }
}

