/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.filter;

import java.io.IOException;
import javax.servlet.FilterChain;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.springframework.util.StringUtils;
import org.springframework.web.filter.OncePerRequestFilter;

public abstract class AbstractRequestLoggingFilter
extends OncePerRequestFilter {
    public static final String DEFAULT_BEFORE_MESSAGE_PREFIX = "Before request [";
    public static final String DEFAULT_BEFORE_MESSAGE_SUFFIX = "]";
    public static final String DEFAULT_AFTER_MESSAGE_PREFIX = "After request [";
    public static final String DEFAULT_AFTER_MESSAGE_SUFFIX = "]";
    private boolean includeQueryString = false;
    private boolean includeClientInfo = false;
    private String beforeMessagePrefix = "Before request [";
    private String beforeMessageSuffix = "]";
    private String afterMessagePrefix = "After request [";
    private String afterMessageSuffix = "]";

    public void setIncludeQueryString(boolean includeQueryString) {
        this.includeQueryString = includeQueryString;
    }

    protected boolean isIncludeQueryString() {
        return this.includeQueryString;
    }

    public void setIncludeClientInfo(boolean includeClientInfo) {
        this.includeClientInfo = includeClientInfo;
    }

    protected boolean isIncludeClientInfo() {
        return this.includeClientInfo;
    }

    public void setBeforeMessagePrefix(String beforeMessagePrefix) {
        this.beforeMessagePrefix = beforeMessagePrefix;
    }

    public void setBeforeMessageSuffix(String beforeMessageSuffix) {
        this.beforeMessageSuffix = beforeMessageSuffix;
    }

    public void setAfterMessagePrefix(String afterMessagePrefix) {
        this.afterMessagePrefix = afterMessagePrefix;
    }

    public void setAfterMessageSuffix(String afterMessageSuffix) {
        this.afterMessageSuffix = afterMessageSuffix;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doFilterInternal(HttpServletRequest request, HttpServletResponse response, FilterChain filterChain) throws ServletException, IOException {
        this.beforeRequest(request, this.getBeforeMessage(request));
        try {
            filterChain.doFilter((ServletRequest)request, (ServletResponse)response);
            Object var5_4 = null;
            this.afterRequest(request, this.getAfterMessage(request));
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            this.afterRequest(request, this.getAfterMessage(request));
            throw throwable;
        }
    }

    private String getBeforeMessage(HttpServletRequest request) {
        return this.createMessage(request, this.beforeMessagePrefix, this.beforeMessageSuffix);
    }

    private String getAfterMessage(HttpServletRequest request) {
        return this.createMessage(request, this.afterMessagePrefix, this.afterMessageSuffix);
    }

    protected String createMessage(HttpServletRequest request, String prefix, String suffix) {
        StringBuffer buffer = new StringBuffer();
        buffer.append(prefix);
        buffer.append("uri=").append(request.getRequestURI());
        if (this.isIncludeQueryString()) {
            buffer.append('?').append(request.getQueryString());
        }
        if (this.isIncludeClientInfo()) {
            String user;
            HttpSession session;
            String client = request.getRemoteAddr();
            if (StringUtils.hasLength(client)) {
                buffer.append(";client=").append(client);
            }
            if ((session = request.getSession(false)) != null) {
                buffer.append(";session=").append(session.getId());
            }
            if ((user = request.getRemoteUser()) != null) {
                buffer.append(";user=").append(user);
            }
        }
        buffer.append(suffix);
        return buffer.toString();
    }

    protected abstract void beforeRequest(HttpServletRequest var1, String var2);

    protected abstract void afterRequest(HttpServletRequest var1, String var2);
}

