/*
 * Decompiled with CFR 0.152.
 */
package org.videolan.media.content;

import java.util.ArrayList;
import org.videolan.media.content.BDHandler;
import org.videolan.media.content.playlist.Handler;

public class PlayerManager {
    private static PlayerManager instance = new PlayerManager();
    private ArrayList registeredPlayers = new ArrayList(1);
    private BDHandler playlistPlayer = null;
    private BDHandler videoDripPlayer = null;
    private ArrayList audioPlayerList = new ArrayList(8);
    private Object playlistPlayerLock = new Object();
    private Object videoDripPlayerLock = new Object();
    private Object audioPlayerLock = new Object();

    public static PlayerManager getInstance() {
        return instance;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void releaseAllPlayers(boolean unconditional) {
        BDHandler[] players = null;
        ArrayList arrayList = this.registeredPlayers;
        synchronized (arrayList) {
            players = this.registeredPlayers.toArray(new BDHandler[0]);
        }
        for (int i = 0; i < players.length; ++i) {
            if (unconditional) {
                players[i].close();
                continue;
            }
            if (players[i].getOwnerContext() == null || !players[i].getOwnerContext().isReleased()) continue;
            players[i].close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void releaseResource(BDHandler player) {
        if (player instanceof Handler) {
            Object object = this.playlistPlayerLock;
            synchronized (object) {
                if (player == this.playlistPlayer) {
                    this.playlistPlayer = null;
                }
            }
            return;
        }
        if (player instanceof org.videolan.media.content.sound.Handler) {
            return;
        }
        System.err.println("unknown player type: " + player.getClass().getName());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean allocateResource(BDHandler player) {
        if (player instanceof Handler) {
            Object object = this.playlistPlayerLock;
            synchronized (object) {
                if (this.playlistPlayer != null && player != this.playlistPlayer) {
                    this.playlistPlayer.stop();
                    this.playlistPlayer.deallocate();
                }
                this.playlistPlayer = player;
            }
            return true;
        }
        if (player instanceof org.videolan.media.content.sound.Handler) {
            return true;
        }
        System.err.println("unknown player type: " + player.getClass().getName());
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void unregisterPlayer(BDHandler player) {
        ArrayList arrayList = this.registeredPlayers;
        synchronized (arrayList) {
            if (this.registeredPlayers.contains(player)) {
                this.registeredPlayers.remove(player);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void registerPlayer(BDHandler player) {
        ArrayList arrayList = this.registeredPlayers;
        synchronized (arrayList) {
            if (!this.registeredPlayers.contains(player)) {
                this.registeredPlayers.add(player);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onPlaylistEnd(int playlist) {
        Object object = this.playlistPlayerLock;
        synchronized (object) {
            if (this.playlistPlayer != null) {
                this.playlistPlayer.endOfMedia(playlist);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onPlaylistTime(int pts) {
        Object object = this.playlistPlayerLock;
        synchronized (object) {
            if (this.playlistPlayer != null) {
                this.playlistPlayer.updateTime(pts);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onChapterReach(int param) {
        Object object = this.playlistPlayerLock;
        synchronized (object) {
            if (this.playlistPlayer != null) {
                this.playlistPlayer.doChapterReach(param);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onMarkReach(int param) {
        Object object = this.playlistPlayerLock;
        synchronized (object) {
            if (this.playlistPlayer != null) {
                this.playlistPlayer.doMarkReach(param);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onPlaylistStart(int param) {
        Object object = this.playlistPlayerLock;
        synchronized (object) {
            if (this.playlistPlayer != null) {
                this.playlistPlayer.doPlaylistStart(param);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onPlayItemReach(int param) {
        Object object = this.playlistPlayerLock;
        synchronized (object) {
            if (this.playlistPlayer != null) {
                this.playlistPlayer.doPlayItemReach(param);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onAngleChange(int param) {
        Object object = this.playlistPlayerLock;
        synchronized (object) {
            if (this.playlistPlayer != null) {
                this.playlistPlayer.doAngleChange(param);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onRateChange(float rate) {
        Object object = this.playlistPlayerLock;
        synchronized (object) {
            if (this.playlistPlayer != null) {
                this.playlistPlayer.updateRate(rate);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onSubtitleChange(int param) {
        Object object = this.playlistPlayerLock;
        synchronized (object) {
            if (this.playlistPlayer != null) {
                this.playlistPlayer.doSubtitleChange(param);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onPiPChange(int param) {
        Object object = this.playlistPlayerLock;
        synchronized (object) {
            if (this.playlistPlayer != null) {
                this.playlistPlayer.doPiPChange(param);
            }
        }
    }
}

