---
myst:
  html_meta:
    keywords: LaTeX, fichiers, fontes, installation, fontes, polices de caractères, 
              polices PostScript
---

# Comment préparer une police de type 1  à l'installation ?

Le processus d'installation d'un jeu de polices de type 1 est assez complexe. 
Nous le traiterons ici en deux temps : 
- d'abord la préparation de la police pour l'installation (détaillée ci-dessous) ; 
- puis l'installation d'une police de type 1 détaillée dans la question 
  "[](/5_fichiers/formats/fontes/installation_de_fontes/installer_une_police_t1)".

De nombreuses polices sont fournies sous forme de polices (La)TeX prêtes à l'emploi : 
ces polices ne nécessitent aucune préparation et peuvent être installées immédiatement.

Cependant, si vous achetez une police auprès d'une fonderie de caractères 
(soit directement, soit par l'intermédiaire d'une boutique en ligne), 
vous devrez probablement suivre les instructions suivantes. 


## Acquérir la police

Un très petit ensemble de polices de type 1 est installé 
dans la plupart des imprimantes PostScript que vous rencontrerez. Pour ces quelques polices 
(dont l'utilisation est couverte par l'extension <ctanpkg:psnfss>), 
vous n'avez pas besoin de la police de type 1 elle-même pour pouvoir imprimer en utilisant la police.

Pour les autres polices de type 1, pour pouvoir imprimer en utilisant la police, 
vous avez besoin du fichier de type 1 lui-même. 
Certaines de ces polices sont disponibles gratuitement 
(elles sont tombées dans le domaine public ou ont été développées 
dans le cadre d'un projet de logiciel libre), 
mais la grande majorité d'entre elles sont des produits commerciaux, 
ce qui vous oblige à dépenser de l'argent.


## Acquérir les ficheirs AFM de la police

Les fichiers AFM contiennent des informations provenant de la fonderie de la police, 
concernant la taille des caractères de la police et la manière dont ils s'assemblent. 
La qualité d'un fournisseur de polices se mesure notamment 
au fait qu'il fournit les fichiers AFM par défaut : si ces fichiers ne sont pas disponibles, 
il est peu probable que vous puissiez utiliser la police avec (La)TeX.


## Renommer les fichiers de la police et les fichiers AFM

Il faut que les noms des fichiers de manière à ce qu'ils correspondent à la 
[la convention de nommage de Berry](/5_fichiers/formats/fontes/les_noms_de_fichiers_des_fontes).


## Générer les fichiers de métrique TeX à partir des fichiers AFM

L'outil le plus courant pour cette tâche est <ctanpkg:fontinst>. 
Sa [documentation](texdoc:fontinst) aide à traiter ce point. 
Le script le plus simple à passer à <ctanpkg:fontinst> est :

```{noedit}
    \latinfamily{xyz}{}
    \bye
```

Ici, `xyz` est le nom de la famille de polices selon la convention Berry. 
Ce script simple est suffisant pour la plupart des usages : 
sa sortie couvre la famille de polices dans les encodages T1 et OT1. 
Néanmoins, avec des polices plus fantaisistes, 
des choses plus élaborées sont possibles avec <ctanpkg:fontinst>. 
Sa [documentation](texdoc:fontinst) les présente en détail.

De plus, <ctanpkg:fontinst> génère également des fichiers de correspondance 
et des fichiers de définition de polices LaTeX (`fd`).

Après avoir parcouru cette liste, vous disposez d'un ensemble de fichiers de polices 
prêts à être installés.


:::{sources}
[Preparing a Type 1 font](faquk:FAQ-prept1font)
:::