---
myst:
  html_meta:
    keywords: LaTeX, généralités, bases, devenir riche sans effort, utiliser LaTeX commercialement,
              faire de la prestation de services LaTeX, édition de livres, graphiste LaTeX
---

# Peut-on gagner de l'argent avec LaTeX ?

*Le contenu actuel de cette page provient du* 
*[LaTeX Ninja blog](https://latex-ninja.com/2019/02/02/earning-money-with-latex/),* 
*avec l'aimable autorisation de son auteur, Sarah Lang.*

## L'expérience de la communauté [#TeXLaTeX](https://twitter.com/hashtag/TeXLaTeX) 

Voici le message Twitter dans lequel j'ai demandé à d'autres amoureux de TeX de me faire part 
de leurs expériences afin de les inclure dans ce message :

> [`@latex_ninja`](https://twitter.com/latex_ninja) : 
> Je travaille actuellement sur un billet intitulé "Comment gagner de l'argent 
> avec LaTeX / faire carrière avec LaTeX". Je serais très heureux de connaître vos expériences 
> en matière de travail rémunéré lié à LaTeX, communauté 
> [`#TeXLaTeX`](https://twitter.com/hashtag/TeXLaTeX) !

Je vais maintenant résumer les réponses que j'ai reçues. 
Mais avant cela : un grand merci à la communauté [`#TeXLaTeX`](https://twitter.com/hashtag/TeXLaTeX) 
--- les personnes les plus amicales et les plus serviables qui soient !


### Où et comment puis-je travailler en utilisant LaTeX ?

D'après le ton général des commentaires, 
il semble que la communauté --- comme moi --- pense que la façon la plus confortable 
et la plus sûre de monétiser ses compétences en LaTeX est dans un environnement universitaire 
où vous seriez amené à utiliser LaTeX pour la composition, 
sans que ce soit forcément l'objet principal de votre poste. 
Vous pouvez être amené à utiliser LaTeX de manière intensive --- 
si vous avez de la chance et si vous recherchez les occasions de le faire --- 
mais vous ne dépendez pas non plus entièrement de lui.

Il est assez difficile de travailler en free-lance en proposant uniquement LaTeX, 
à moins d'avoir de bons contacts dans un environnement 
où la composition en TeX fait partie de la vie quotidienne. 
Cependant, si vous aviez la chance de trouver un tel environnement,
il est probable que vous auriez beaucoup de concurrence 
et que les personnes qui utilisent constamment LaTeX n'auraient de toutes façons pas besoin d'aide. 
Du moins, pas assez souvent pour que vous puissiez vivre de ce seul service. 
Des entreprises comme [le-tex](https://www.le-tex.de/en/index.html) proposent non seulement LaTeX, 
mais aussi des services autour d'XML, InDesign ou MS Office. 
Il s'agit donc plutôt d'une gamme globale de services de composition 
et que d'une simple offre de prestations en LaTeX. Il y a cependant des indépendants qui utilisent LaTeX. 
Martin Sievers (du [groupe d'utilisateurs](/1_generalites/documentation/listes_de_discussion/groupes_d_utilisateurs)
[allemand DANTE e.V.](https://www.dante.de/)) m'a gentiment mentionné certains d'entre eux :

> Martin Sievers, [`@TeX4Publication`](https://twitter.com/tex4publication) 19 janv. : 
> des sociétés comme [`@letexml`](https://twitter.com/letexml) propose d'habitude plus que 
> LaTeX (XML, InDesign, Office). [`@TeXhackse`](https://twitter.com/TeXhackse), 
> [`@speedata`](https://twitter.com/speedata) et [`@khzimmer2`](https://twitter.com/khzimmer2) devraient
> pouvoir vous en dire plus sur le travail free-lance.

**Il semble que les centres d’[humanités numériques](wpfr:Humanités_numériques)** 
**soient des endroits où les ouvriers utilisant LaTeX ont trouvé des environnements conviviaux** 
où ils peuvent faire de leur passion une source d'argent (entre autres tâches). 
C'est assez logique. Étant donné que le développement de [XSL-FO](wpfr:XSL-FO) est arrêté depuis 2012
et que LaTeX se porte toujours aussi bien, 
l est normal de progressivement transformer les données des sciences humaines en LaTeX 
pour créer des documents imprimables. 
À cela s'ajoute le grand choix de possibilités et d'extensions utiles que LaTeX offre pour des besoins 
(à peu près) uniques aux sciences humaines (comme l'extension <ctanpkg:reledmac> 
pour les apparats critiques complexes ou la composition de polices non-latines ou de caractères non-standards, 
par exemple).


### À quoi ressemblera ce travail, selon toute vraisemblance ?

**Ceux qui vivent de LaTeX disent qu'ils créent surtout des maquettes** ou font du back-office. 
Les conseils que j'ai reçus n'étaient pas tous intuitifs pour moi, 
comme l'insistance sur le fait qu'il est important 
que vous soyez capable de discuter des solutions avec les clients. 
En effet, même si pour vous, la passion pour la composition et les aspects techniques de LaTeX sont 
au cœur de ce que vous imaginez, **vous serez avant tout un prestataire de services**. 
Un métier aux coutumes très particulières --- comme le fait que votre client a toujours raison 
et que vous devrez lui donner le résultat qu'il souhaite, 
et pas seulement vous amuser à programmer ce que vous pensez être le plus élégant (ou le plus amusant). 
C'est un aspect que les gens ont tendance à oublier lorsqu'ils essaient de transformer leurs passions en emplois
(ou déménager sur leur lieu de vacances préféré en tant qu'expatriés). 
Une fois qu'il ne s'agit plus d'un simple loisir, mais d'un véritable gagne-pain (ou de votre vie quotidienne), 
vous pouvez avoir un ressenti très différent du passe-temps que vous aimiez. 
**La réalité ne sera peut-être pas le rêve que vous aviez imaginé. Êtes-vous sûr d'être prêt pour cela ?**

Si vous êtes conscient de ces aspects, que vous savez plus ou moins à quoi vous attendre 
et que vous pensez toujours que c'est une bonne idée, 
alors ça l'est probablement et vous devriez au moins essayer. 
Je vous expliquerai plus loin dans cet article la meilleure façon d'aborder la question.

En ce qui concerne la prestatation de services, 
le travail free-lance en LaTeX ressemble beaucoup au travail typique des Humanités numériques : 
**vous devez communiquer vos connaissances techniques** 
**de manière à ce qu'elles soient compréhensibles pour quelqu'un qui n'a peut-être pas ce bagage technique.** 
Les clients peuvent avoir des idées ou des besoins très spécifiques, 
même s'ils ne sont pas conformes à ce que vous pensez être le mieux. 
Certains d'entre eux ne veulent pas de bonnes solutions, 
mais plutôt des solutions rapides, bon marché et sales. 
Si vous envisagez de faire du consulting LaTeX votre métier, il vaut être prêt à accepter cela. 
**Même dans les humanités numériques, un domaine où l'on comprend généralement mieux une technologie comme LaTeX,**
**les gens n'apprécieront peut-être pas sa beauté de la même façon que vous.** 
**La plupart des gens veulent juste que les choses soient faites, et rapidement, que l'outil soit beau ou pas.**

> Marei, `@TeXhackse` 28 janvier.
> 
> Autre chose, que Patrick a également mentionné : 
> **il y aura des gens qui chercheront des solutions bon marché, rapides et sales.** 
> **Ce n'est pas quelque chose qu'un amoureux de LaTeX peut apprécier.** 
> Mais c'est pour de l'argent. Tout le monde devra faire cela de temps en temps. (...)
> Je travaille avec des universités qui génèrent des modèles de conception d'entreprise 
> et des mécanismes d'automatisation pour la documentation technique, 
> la correspondance commerciale ou les contrats. 
> Ce qui est génial, c'est que je peux choisir les projets que j'accepte.

Certains d'entre eux précisent aussi que leurs projets sont moins axés 
sur le travail en free-lance que sur l'idée générale de l'Open Source, 
qui consiste à diffuser une technologie qui en vaut la peine. 
Certains ciblent les personnes ayant une formation technique, 
qui utilisent déjà beaucoup LaTeX mais qui pourraient avoir besoin d'aide pour les détails, 
tandis que d'autres se concentrent sur l'apport de cette formidable technologie 
aux personnes qui ne font pas encore partie du "groupe cible" typique. 
C'est également ce que je fais avec ce blog : 
j'essaie de fournir un contenu intéressant pour ceux qui sont déjà 
des utilisateurs avancés de LaTeX et qui veulent s'améliorer, mais d'un autre côté, 
j'essaie de fournir des bases de départ pour un public qui n'est pas encore convaincu de l'utilité de LaTeX.

La commercialisation de vos services de composition ressemble beaucoup 
à celle de n'importe quel type de conception graphique en free-lance (je suppose). 
**Vous aurez un public cible assez restreint, mais les gourous disent toujours qu'il faut trouver sa niche.**
Alors peut-être que c'est ça. 
J'ai personnellement gagné de l'argent en créant des affiches avec LaTeX, par exemple. 
Le logiciel n'était pas une obligation, j'étais libre de produire le résultat de la manière que je voulais. 
Mais LaTeX est ce que je fais de mieux, alors c'est ce que j'ai fait. 
À cet égard, c'était comme n'importe quel autre travail sous contrat. 
Notez que contribuer au projet LaTeX ne vous apportera probablement pas grand-chose 
(financièrement parlant) puisqu'il s'agit d'un projet Open-Source.

Donc, pour résumer, **"travailler en utilisant LaTeX" va du développement de vos outils basés sur LaTeX,** 
**au travail en tant que consultant LaTeX en passant par la création de maquettes.** 
Maintenant, je veux poursuivre avec quelques conseils concrets sur la façon de s'y prendre.


## Conseils pratiques

### Trouvez un job où vous pourrez utiliser LaTeX, pas un où vous êtes spécifiquement embauché pour le faire

**Intégrer LaTeX dans votre travail actuel peut être relativement aisé, en fonction de votre emploi.** 
Ou bien choisissez un poste où il sera probablement possible d'intégrer LaTeX, 
puis bâtissez-vous une bonne réputation et peut-être obtiendrez-vous plus de travail impliquant LaTeX 
et serez-vous sollicité pour travailler officiellement avec LaTeX. 
Il sera beaucoup plus facile d'emprunter cette voie que d'essayer de se lancer directement comme consultant
free-lancer en LaTeX. Et, plus important encore, ce sera beaucoup plus sûr pour vous. 
**Je ne vous conseille pas de quitter votre job actuel pour essayer de travailler**  
**dans un domaine où vous ne savez pas encore si vous avez vraiment un marché** 
**et si la demande est suffisante pour que vous puissiez en vivre.**


### Suis-je assez compétent pour effectuer un travail rémunéré avec LaTeX ?

Si vous pouvez décrocher un emploi rémunéré en le faisant, je dirais oui. 
**N'attendez pas d'être un "expert"**, car c'est un terme subjectif 
et vous ne vous sentirez peut-être jamais expert, même dans 10 ans. 
**Si vous voulez vous lancer, autant le faire maintenant.** 
**Au cas où vous seriez coincé dans un projet,** 
**vous pouvez toujours chercher ce dont vous avez besoin sur internet.** 
**Si vous êtes capable de chercher des informations en ligne, de les adapter à vos besoins** 
**et de les faire fonctionner, vous êtes prêt.** 
Par ailleurs, si vous n'êtes pas encore certain de pouvoir facturer vos services, 
**travaillez gratuitement sur 1 à 3 petits projets non critiques ni urgents.** 
**Cela vous permettra de vous constituer un portfolio et de gagner en confiance.** 
Si les choses tournent mal, vous n'aurez pas à vous inquiéter outre mesure puisque vous n'aurez pas été payé.

De plus, je suppose que vous ne serez sans doute pas en mesure de décrocher un emploi rémunéré immédiatement. 
Commencer par un projet gratuit peut donc être une bonne solution. 
Cela vous permet également **d'évaluer si le service que vous souhaitez fournir est réellement demandé.** 
**Si vous n'êtes pas sûr des compétences que vous possédez,** 
**ne proposez que ce que vous êtes sûr de pouvoir gérer** et tout ira bien.


### Commencez par un projet secondaire

"Testez" votre idée d'entreprise dans le cadre d'un *projet secondaire*. 
Essayez de trouver une petite tâche rémunérée à accomplir. 
Ainsi, une fois que vous aurez décidé de commencer à travailler réellement avec LaTeX, 
vous aurez déjà des clients prêts à acheter. 
C'est le conseil que donnent la plupart des guides sur la façon de devenir free-lance ou entrepreneur, 
et c'est un conseil sensé. 
**Ne quittez pas votre emploi si vous n'êtes pas sûr de pouvoir vivre de votre nouvelle idée d'entreprise**. 
Évaluez si l'idée vaut la peine de se lancer et recueillez des preuves objectives en obtenant un travail rémunéré.
**Voyez si vous aimez vraiment ce travail** 
(même si vous aimez LaTeX, vous pourriez finir par détester le faire pour de l'argent et aux conditions du client).
**Commencez comme une activité secondaire et ne passez à autre chose qu'une fois que c'est rentable.** 
Lisez [*Soft Skills*](isbn:9781617292392) de John Sonmez 
et le [*Software Dev Career Guide*](isbn:978-0999081419) pour trouver plus de conseils 
sur la création de votre propre entreprise.


### Quelques exemples de descriptions de postes sur Upwork

Pour commencer à travailler en free-lance, 
pensez à accepter quelques mini-travaux sur des plateformes de free-lance en ligne. 
Par exemple, j'ai trouvé des petits boulots comme ceux-ci en faisant une recherche rapide sur Google :

> **Nous recherchons un développeur expérimenté capable d'automatiser un convertisseur latex à partir de plusieurs sources.**

> **Conversion d'un document Word (cahier d'étude de mathématiques) en LaTeX en utilisant** 
> **un modèle donné**. Je cherche un utilisateur de LaTeX compétent qui connaît aussi les mathématiques.
>
> Il y a environ 10 documents qui doivent être convertis en un modèle LaTeX.
>
> Le modèle est déjà prêt à l'emploi.
>
> J'ai téléchargé un exemple de livret utilisant le modèle et un exemple de document 
> de contenu (*Données bivariées*). Chaque livret peut avoir entre 10 et 40 pages, mais 
> certaines sont déjà dactylographiées. Certaines sont écrites à la main. J'ai besoin 
> de quelqu'un qui a un code propre. J'ai besoin de quelqu'un qui sait utiliser 
> Ti*k*Z et/ou Pgf-plot afin de pouvoir dessiner des diagrammes proprement. S'il 
> vous plaît, n'insérez pas d'images.

> **Création d'équations prêtes à être imprimées**. Les équations ont été créées 
> à l'aide de l'éditeur d'équations de Word, avec une cohérence médiocre. (...) J'aimerais 
> que les équations dans le fichier kindle et le fichier imprimé soient plus propres. Je 
> crois savoir qu'il existe un logiciel (GrindEQ) qui peut le faire 
> rapidement. Idéalement, tout le fichier pourrait être corrigé en une seule fois, les 
> équations restant à leur place dans le texte.

> **Aide pour des citations en Latex**. J'ai écrit une thèse de MBA en Latex, en 
> utilisant [Overleaf.com](/2_programmation/compilation/compiler_en_ligne). J'ai besoin 
> de suivre le style de citation APA, mais j'ai un problème pour le faire. (...) J'ai 
> également du mal à indiquer dans mon code comment les citations d'un site web et leur date 
> d'obtention doivent être affichées (...). Alors que j'avais initialement introduit, dans 
> le code latex, des lignes vides entre chaque paragraphe et le suivant, celles-ci 
> n'apparaissent plus lorsque je compile mon code. J'ai dû faire une erreur quelque 
> part. J'ai besoin de retrouver ces lignes vides. (...) Les livrables sont les 
> suivants : **1.** Les références suivent le style de citation indiqué dans le 
> lien ci-dessus. **2.** Les références des sites web doivent suivre un certain 
> style. **3.** Introduction de lignes vides entre chaque paragraphe et le suivant. Vous 
> êtes priés d'indiquer les lignes de code que vous avez écrites pour mettre en œuvre 
> les changements.


## Réponses à des questions trouvées en ligne

Il existe une [question StackOverflow](https://tex.stackexchange.com/q/135295) 
sur la possibilité ou la manière de gagner de l'argent avec LaTeX 
et je crois qu'il y a eu 
[cette question sur Quora](https://www.quora.com/How-can-I-make-money-from-the-LaTeX-programming-language) 
où l'on a dit que l'on ne pouvait pas gagner d'argent avec LaTeX. 
C'est ce qui a inspiré mon billet, et j'ai donc décidé d'y répondre explicitement à nouveau.


### La question sur le site de Quora

Voici la réponse de Quora à la question 
"[Comment puis-je gagner de l'argent avec le langage de programmation LaTeX ?](https://www.quora.com/How-can-I-make-money-from-the-LaTeX-programming-language)".
Je ne suis pas tout à fait sûr que la personne pensait ce qu'elle écrivait 
car je trouve cette réponse très biaisée et franchement bizarre et totalement irréaliste :

> Certaines personnes aiment [PRAGMA ADE](http://www.pragma-ade.nl/), mais elles 
> ont développé [ConTeXt](/1_generalites/glossaire/context), un LaTeX bien meilleur
> avec un moteur TeX fonctionnant avec un [Lua](wpfr:Lua) intégré. Ce sont de vrais 
> experts de TeX et de la fabrication de beaux documents. De plus, il y a beaucoup de 
> gens qui savent comment saisir des documents LaTeX ; vous aurez donc beaucoup de 
> concurrence. Par ailleurs, les compétences en LaTeX ne sont pas très demandées 
> (peu d'emplois). Et le fait de taper quotidiennement un grand nombre de documents 
> LaTeX vous ennuiera probablement à un moment ou à un autre ou vous causera des troubles
> musculo-squelettiques. **Je ne recommanderais donc pas le modèle économique consistant**
> **à gagner de l'argent grâce à LaTeX. Mais bon, ce n'est que mon opinion. Je peux me tromper ^^**

Le commentateur dit à juste titre que certaines personnes gagnent de l'argent grâce à LaTeX. 
Mais ensuite, il affirme à tort que "les compétences en LaTeX ne sont pas très demandées". 
Je trouve que les compétences avancées en LaTeX ne sont, en fait, pas si courantes. 
Bien sûr, n'importe qui peut rapidement taper un document LaTeX qui sera compilé. 
Mais pour des utilisations avancées ? Pas d'après mon expérience. 
De même, que dire du commentaire sur les troubles musculo-squelettiques? Honnêtement ?


### Réflexions sur la discussion de StackOverflow

[Voici la question posée sur StackOverflow](https://tex.stackexchange.com/questions/135295/how-can-i-make-some-money-out-of-my-tex-skills) :

> Après avoir aidé une amie à concevoir un prospectus pour une société de télécommunications 
> (pour lequel elle a reçu une rémunération décente), **je me demande s'il existe un marché** 
> **pour les travaux TeX en free-lance**, sur lequel je pourrais peut-être mettre un peu 
> d'argent de côté pour des jours sans. **En tant que TeXnicien amateur avec des connaissances** 
> **générales limitées en matière de conception graphique,** 
> **mais avec un portefeuille croissant de documents de bonne qualité produits avec TeX** 
> **et des logiciels apparentés** :
>
> 1. à qui devrais-je tenter de vendre mes compétences TeX (si ces personnes existent) ?
> 2. est-ce que, par exemple, une maison d'édition serait intéressée ? Ou est-ce qu'ils 
>    recherchent généralement des personnes ayant un bagage beaucoup plus important que 
>    le mien en matière de TeX et assimilés ?
> 3. si vous êtes directement payé pour vos compétences en TeX, comment avez-vous commencé ?

Ci-dessous, je cite certaines des réponses et les commente.

> Ma réponse n'a pas vocation à être une référence et n'est pas positive, je me contenterai 
> donc d'un commentaire : le problème est que le principal consommateur de TeX, le monde 
> universitaire, est constitué d'un grand nombre de personnes très fières et indépendantes 
> qui, pour la plupart, ne valorisent pas les compétences dans ce domaine mais ne laisseraient 
> personne le faire à leur place. Vous ne gagnerez donc pas d'argent avec eux. Vous 
> pourriez gagner de l'argent auprès de leurs éditeurs universitaires, mais je doute qu'ils 
> aient besoin de travail en free-lance ; étant donné que les auteurs rédigent tous leurs 
> articles eux-mêmes, ils gardent probablement un éditeur TeX pour les normaliser. **Je n'ai** 
> **jamais trouvé de bonne réponse à votre question.** --- Ryan Reich, 27 septembre 2013 à 1h58

Pourquoi certaines personnes ont-elles tendance à insulter le monde universitaire 
tout entier sans rien savoir de lui ? Pourquoi les gens pensent-ils que c'est acceptable ? 
J'ai également remarqué ce discours général anti-universitaire tout récemment dans le livre 
[Antifragile](isbn:978-1400067824) que j'avais envie de lire, 
mais que j'ai refermé parce que j'avais l'impression d'être constamment insulté... 
Le monde universitaire est plutôt diversifié et tout le monde ne s'y ressemble pas. 
Mais si vous n'aimez pas les gens (à cause de vos préjugés par exemple) et que vous le laissez paraître, 
ils le remarqueront probablement et, par conséquent, ne vous traiteront pas aussi gentiment
 qu'ils le feraient normalement. Je travaille dans le milieu universitaire et oui, bien sûr, 
 il y a des gens arrogants et difficiles, mais la plupart du temps, 
 ce sont des gens très gentils qui seront heureux que vous les aidiez ! 
 On peut trouver des personnes arrogantes dans n'importe quel domaine, et 
 --- sans vouloir insulter qui que ce soit --- l'arrogance est en fait assez répandue 
 chez beaucoup de spécialistes techniques, alors je ne vois pas vraiment pourquoi ils aiment 
 porter des jugements globaux sur les universitaires alors que leur domaine n'est pas vraiment meilleur.
 En général, les universités sont remplies de personnes qui sont censées travailler 
 comme une armée d'un seul homme et à qui on demande d'exceller dans des tas de compétences 
 qui ne leur ont jamais été enseignées officiellement (de la comptabilité à la mise en page, 
 en passant par la rédaction de demandes de subventions et, bien sûr, l'enseignement). 
 Ils seront donc reconnaissants de recevoir de l'aide.

Au moins, j'espère apporter avec ce billet la bonne réponse à cette question, 
qu'il dit n'avoir jamais trouvée jusqu'à présent.

> J'ai des amis qui prennent des documents qui ont été mis en format TeX par les 
> auteurs, et **qui les "améliorent" pour qu'ils fonctionnent avec les paquets spécifiques**
> **propres à un journal, etc. Ils gagnent pas mal d'argent (30 USD/h, 40+ heures par** 
> **semaine**). AJOUT : Je devrais mentionner qu'ils sont employés par le 
> journal. --- Steve D., 27 septembre 2013 à 6h10

Certains mentionnent des personnes employées par des journaux qui "améliorent" 
ou corrigent les articles soumis et peuvent en vivre.

> Je dirais que là où le produit final doit être un PDF, il y a un marché. Là où TeX a un 
> avantage sur la concurrence, à mon avis, c'est dans la génération automatique de 
> documents. Pensez aux catalogues générés à partir de bases de données relationnelles 
> et autres documents de ce genre. --- morbusg, 27 septembre 2013 à 7h22

Oui, *voilà*! C'est tout à fait mon avis !

> @RyanReich Je suis d'accord avec vous sur le fait que l'on ne peut pas gagner de l'argent
> avec des travaux universitaires, mais dans mon cas, c'est dû au fait qu'**il n'y a en** 
> **général pas d'argent dans la sphère universitaire. (...) Le marché pourrait être** 
> **celui des livres scientifiques ou techniques, où TeX a ses** 
> **avantages.** --- Pygmalion, 27 septembre 2013 à 7h48
>
> @Pygmalion **Je pense que de nombreux professeurs titulaires ont suffisamment de fonds** 
> **pour embaucher des personnes pour faire leur travail de bureau, et dans de nombreux** 
> **cas, ils le font**. Cependant, même s'ils franchissent la barrière laissant à quelqu'un 
> d'autre le soin d'écrire l'article pour eux, il est de toute façon plus facile et 
> moins coûteux de faire en sorte que cette personne soit **un étudiant de premier cycle** 
> **et non un travailleur indépendant**. --- Ryan Reich, 27 septembre 2013 à 14h11

Eh bien, ici je peux fournir quelques renseignements connus des seuls initiés : 
il n'y a pas beaucoup d'argent dans le monde universitaire, 
contrairement à ce que pensent beaucoup de gens de l'extérieur. En particulier dans les sciences humaines, 
tout le monde est fauché et il n'y a pas d'argent. Cependant, vous découvrirez qu'après tout, 
il peut y avoir un peu d'argent pour des tâches comme celle-ci, de temps en temps.

Et, en ce qui concerne les stagiaires de premier cycle : oui, c'est sans doute vrai. 😉

> **Vous pouvez gagner de l'argent. Il est impossible d'obtenir ne serait-ce que les** 
> **tarifs d'un consultant en logiciel en free-lance.** --- Martin Schröder, 27 septembre 2013 à 7h04

Ceci tombe sous le sens, si vous êtes un développeur de logiciels indépendant, 
car les gens obtiennent des rémunérations beaucoup plus élevées 
pour de la programmation et de l'informatique en général. 
Si vous avez l'habitude de travailler dans le domaine des sciences humaines à l'université, 
vous serez probablement en mesure de gagner correctement votre vie et de trouver un emploi que vous aimez,
si vous êtes suffisamment patient.

Les commentaires mentionnent que les services gratuits, 
comme [LaTeX typesetting](https://www.latextypesetting.com/), 
pourraient ruiner votre business (d'après ce que j'ai vu sur le site web, ce n'est même pas un service gratuit...),
puisque c'est de la concurrence qui donne une valeur nulle au service. 
Mais je ne pense pas que ce soit vraiment un point pertinent. 
Bien sûr, il existe des ressources gratuites, 
mais une personne prête à payer ne représente pas le même client 
que celle qui fera le travail elle-même si on lui fournit les bons outils. 
Vos clients sont ceux qui ne peuvent ou ne veulent pas faire le travail eux-mêmes, 
alors ne vous laissez pas effrayer par ces commentaires.

> Je ne considère pas comme une erreur de faire de la publicité pour ce site : ce n'est 
> pas mon concurrent. Je ne m'adresse pas à des clients qui ont une connaissance plus 
> ou moins bonne de LaTeX et qui ont les compétences et le temps de poser des questions 
> simples et bien formulées avec un 
> [ECM](/1_generalites/documentation/listes_de_discussion/comment_rediger_un_exemple_complet_minimal) 
> auxquelles je peux répondre en 10 minutes : les frais généraux de 
> comptabilité, etc. absorberaient le gain. **Mes clients ont beaucoup d'erreurs, de grandes** 
> **maquettes (souvent défectueuses), ne savent pas par où commencer pour résoudre leurs problèmes** 
> **ou pour mettre en œuvre certaines exigences et sont pressés par le temps. Ils veulent une** 
> **assistance continue pendant des jours (y compris pour des questions "idiotes" ou** 
> **localisées)**. --- Ulrike Fischer, 27 septembre 2013 à 7h46
>
> Vous devriez également envisager de rendre votre code source inaccessible à vos clients  
> pour empêcher d'autres personnes de l'utiliser gratuitement (c'est une de mes stratégies 
> commerciales). --- kiss my armpit, 27 septembre  2013 à 8h04
>
> **Dans le domaine de l'aide en LaTeX, il est pratiquement impossible de garder le code** 
> **à l'écart du client. Il est également impossible d'éviter qu'ils apprennent à gérer** 
> **les problèmes de LaTeX eux-mêmes : c'est en fait une partie vitale de mon service.** De 
> plus --- désolée --- mon but principal n'est pas de soutirer le plus d'argent possible 
> aux autres. J'aide les gens gratuitement depuis de nombreuses années et je n'ai pas 
> l'intention d'arrêter. Mes clients reçoivent tout le code --- ils peuvent l'ajouter 
> aux tonnes de code gratuit qui circulent de toute façon et le (ré)utiliser s'ils ont 
> les compétences pour le faire. --- Ulrike Fischer, 27 septembre 2013 à 9h20

Mes réponses d'Ulrike Fischer sont très pertinentes, bien sûr.

> Le seul moyen que j'estimerais réaliste est de fournir des services de dactylographie 
> aux professeurs, mais cela nécessite généralement des connaissances spécifiques 
> à un domaine... Ainsi, bien qu'il s'agisse d'une compétence appréciable, LaTeX ne 
> vous rendra pas riche.

La mise en page de documents pour les enseignants-chercheurs ne nécessite pas 
nécessairement des connaissances spécifiques au domaine. 
Une idée générale de ce qui s'y passe et un certain intérêt pour le sujet ne font pas de mal, cependant.
Par ailleurs, comme le suggèrent certains commentaires, 
vous n'écrirez pas l'article d'un chercheur et il ne considérera pas que votre travail empiète sur le sien. 
C'est ridicule et cela montre simplement que les commentateurs ne connaissent pas le monde universitaire. 
L'édition universitaire (avec l'évaluation par les pairs, etc.) 
est une activité qui repose beaucoup sur du travail collaboratif, 
et c'est une partie tout à fait normale du travail universitaire.

De plus, **c'est vrai, ça ne vous rendra probablement pas riche.** 
**Le travail dans les sciences humaines non plus.** 
**Mais c'est une passion pour beaucoup de gens et le fait d'aimer son travail a une valeur en soi.**


### Je réponds encore une fois à la question

**Oui, vous pouvez tout à fait gagner de l'argent avec LaTeX.** Mais comme pour tout autre travail, 
**vous devez vous placer dans un environnement où il y a une demande suffisante pour le service que vous fournissez.** 
Par conséquent, **vous devez vous trouver dans un endroit où les choses sont mises en page et publiées.** 
Votre première rencontre pourrait se faire par **une maison d'édition**. 
Mais il sera probablement difficile d'y entrer sans références professionnelles 
et la maison d'édition aura déjà ses propres méthodes de travail. 
S'ils n'utilisent pas déjà LaTeX et qu'ils ne voient pas pourquoi ils devraient changer tout leur flux de travail,
ils ne vont probablement pas embaucher quelqu'un sans qualification ou expérience 
dans le domaine de la publication et lui confier la grande responsabilité de tout révolutionner.

Donc je recommanderais plutôt de commencer avec **les universités** 
**Des tonnes de choses sont publiées ici**, qu'il s'agisse de dépliants d'information, 
d'affiches publicitaires, d'affiches de conférence, de présentations PowerPoint ou de livres. 
**La demande est énorme, mais il n'y a pratiquement pas de professionnels de la composition pour y répondre.**
Ici, l'édition est une activité que les gens pratiquent le plus souvent en plus de leurs responsabilités professionnelles
et considèrent souvent qu'elle est ennuyeuse et chronophage. 
Dans les universités, de nombreuses personnes n'ont jamais appris officiellement à mettre en page, 
éditer et publier des documents, et pourtant elles doivent constamment le faire. 
Beaucoup d'entre elles sont très occupées et peuvent même avoir les moyens de sous-traiter 
certains travaux (comme les professeurs), de sorte que vous pourriez réellement travailler 
pour eux au lieu de vous contenter de les consulter. 
Pour les autres, qui n'ont pas beaucoup de ressources à leur disposition, toute aide serait très appréciée. 
**La plupart de ces personnes ne sont pas elles-mêmes des professionnels de la typographie.** 
**Elles ne se soucieront donc probablement pas ou ne remarqueront pas que vous n'êtes pas un professionnel** 
**ou que vous n'avez pas de qualification officielle.** 
Donner un coup de main ici est un moyen peu risqué d'acquérir de l'expérience. 
Sans parler de tous les **étudiants** qui pourraient avoir besoin d'aide pour la composition de leur thèse. 
**Vous devez simplement vous assurer que les gens savent quels services vous offrez.** 
Les universités peuvent également rechercher des services de conception graphique, etc. 
Cela dit, ce n'est probablement pas quelque chose pour lequel vous serez engagé sans expérience préalable.


## Ciblez les "éditeurs par accident" et offrez une valeur ajoutée attractive

**Vous pourriez commencer à travailler en free-lance pour aider les milliers** 
**d’"éditeurs par accident" qui hantent les universités.** 
Dans ce cas, il sera très important qu'ils connaissent vos services (faites de la publicité sur le campus) 
ou qu'ils vous contactent personnellement. Si vous le demandez gentiment, 
des âmes charitables seront peut-être disposées à transmettre votre contact 
via la liste de diffusion de leur département ou de leur faculté. 
**Il y a toujours quelqu'un qui a besoin d'aide pour de la mise en page.** 
**Vous pourriez même être compétitif par rapport à des concurrents plus expérimentés** 
**en étant simplement beaucoup moins chers (soyez quand même sûr de ne pas perdre d'argent en baissant vos tarifs).**

La plupart du temps, les universitaires n'ont pas besoin des résultats parfaits 
qu'ils pourraient obtenir d'un "vrai" professionnel. Ils ont seulement besoin de quelque chose de correct, 
quelque chose qui soit juste un peu mieux que ce qu'ils auraient pu faire eux-mêmes. 
Dans mon expérience, les gens étaient surtout ravis de certains résultats super simples que je leur fournissais. 
Ils ne sont pas forcément en mesure de juger si la qualité est meilleure que celle à laquelle ils sont habitués. 
Le simple fait que LaTeX soit nettement *différent* de MS Word les distingue de leurs collègues, 
même s'ils ne sont pas *vraiment* en mesure d'apprécier ou de juger la supériorité typographique.


## Définir son profil

Lorsque vous définissez votre stratégie marketing, 
assurez-vous d'avoir une idée claire des services que vous êtes prêt à fournir : par exemple, 
les services informatiques des universités pourraient être un endroit où vous pourriez trouver un emploi 
si vous vous concentrez sur l'aide à l'installation et au démarrage de LaTeX, 
un peu comme [Troubleshooting-TeX](http://www.troubleshooting-tex.de/index-en.php) peut-être. 
Les universités ont également tendance à avoir leurs propres maisons d'édition, 
ce qui pourrait être un endroit où vous pourriez vous retrouver. 
L'édition universitaire peut également être intéressante si vous êtes prêt 
et capable de combiner votre travail LaTeX avec la correction d'épreuves, etc. 
Les universités techniques et les maisons d'édition utilisent fréquemment LaTeX 
dès qu'il s'agit de mathématiques, à cause des formules.


## Mon expérience personnelle

En fait, oui, ça m'est déjà arrivé : j'ai déjà gagné de l'argent en faisant du LaTeX. 
Je mettais en page des textes pour des expositions. 
J'ai également mis en page deux de mes propres livres (ce qui n'était pas, à proprement parler, 
un travail rémunéré, mais au moins la preuve que ma mise en page avait été acceptée par une maison d'édition). 
Je fais un peu de LaTeX dans le cadre de mes travaux en humanités numériques 
(affiches de conférences, extraction des données de notre dépôt, 
création d'une feuille de style pour les extractions en PDF de notre dépôt, 
création de feuilles de travail pour un projet numérique scolaire). 
Je fais de la mise en page pour une société scientifique dont je fais partie. 
J'ai enseigné un peu de LaTeX dans un cours sur l'annotation. J'aide des amis à utiliser LaTeX. 
**Comme vous le voyez, c'est beaucoup de travail non rémunéré.** 
**Mais cela permet de se forger des références et, de temps en temps,** 
**lorsqu'il y a de l'argent disponible pour des travaux de composition, je peux en bénéficier.** 


## Par où commencer ?

**Donc, pour répondre à la question principale, à savoir si vous pouvez gagner de l'argent en utilisant LaTeX,**  
**je dirais : oui ! Mais... ce sera plus facile dans un environnement universitaire** 
**et il vaut mieux le faire étape par étape en construisant vos références** 
**pendant que votre source de revenus vient principalement d'une autre activité.** 
Ensuite, une fois que vous aurez fait cela (publiquement) pendant quelques années, 
vous pourrez peut-être le faire à temps plein. 
Cependant, je ne vous conseille pas de viser le plein temps très rapidement. 
**Essayez plutôt d'obtenir un premier emploi rémunéré en rapport avec LaTeX et soyez actif dans la communauté.** 
**Assurez-vous que les gens savent que vous proposez des travaux rémunérés en LaTeX** 
**et faites-en la publicité de manière subtile.** 
**Les gens ne réalisent peut-être pas encore qu'ils pourraient avoir besoin** 
**de quelqu'un qui fait du travail LaTeX contre de l'argent.** 
Si notre entourage ne sait même pas ce qu'est LaTeX et quels en sont les avantages, 
vous ne trouverez probablement pas de travail. 
**Intéressez et sensibilisez les gens à LaTeX.** 
**Mentionnez-le dès que vous le pouvez** (sans devenir ennuyeux quand même !).

Vous pourriez également être en mesure de décrocher un emploi "normal" dans le domaine de la composition 
ou même de la conception graphique et de **le faire avec LaTeX au lieu des autres outils disponibles** 
(du moins, c'est ce que j'ai fait). **Vérifiez si les gens aiment les résultats. Faites-en la publicité.** 
**Faites de LaTeX votre niche et assurez-vous que les gens la connaissent.**

**Vous pouvez donner des cours sur LaTeX** (dans les universités, les maisons d'édition, etc. 
--- la demande n'est pas énorme, mais si vous pouvez trouver votre niche de clients, c'est possible). 
Encore une fois, l'environnement universitaire est votre ami.

**Placez-vous dans un environnement où la demande en matière de mise en page et d'édition est élevée**,  
comme une université.

**Apprenez aux doctorants à composer leur thèse. Proposez de convertir les documents MS Word en LaTeX** 
(en même temps que la correction des erreurs éventuelles, voire la relecture si vous êtes sûr d'en être capable).

**Dans les universités, des foules de gens finissent comme éditeurs** 
**alors qu'ils n'ont jamais appris à mettre quoi que ce soit en page.** 
Ils sont généralement autodidactes et se débrouillent bien, mais vous pouvez soit répondre à leurs besoins 
et leur proposer de faire de la mise en page pour eux (s'ils ont le budget pour engager quelqu'un pour le faire), 
soit proposer des cours pour les "éditeurs par accident". 
Et il y en a vraiment beaucoup dans les universités, croyez-moi. 
La plupart d'entre eux seraient sans doute plus attirés par une initiation à Adobe Illustrator. 
Mais, selon la quantité de formules qu'ils ont à composer, ils pourraient être intéressés.

**De nombreuses personnes ont déjà entendu parler de LaTeX, mais l'obstacle initial à franchir est trop important.** 
**Si vous pouvez faciliter cette initiation et la rendre agréable,** 
**vous pourriez vous retrouver avec des clients précieux.** Vous devez juste être capable de les convaincre, 
pourquoi ils devraient prendre la peine d'utiliser LaTeX. 
Vous trouverez quelques tentatives d'explication sur mon blog. 😉 
N'hésitez pas à les utiliser pour votre propre marketing !


## Mais si j'apprends à quelqu'un à le faire lui-même, ne vais-je pas perdre les rares clients dont je dispose ?

Eh bien, non. Avez-vous déjà lu [Steal like an artist](isbn:978-2761941143) d'Austin Kleon ? 
Pour le résumer très brièvement, il affirme que dans le travail créatif, 
nous "volons" constamment, de toutes manières. C'est ce qu'on appelle l'inspiration. 
Le marché de la création s'épanouit donc si nous partageons. 
Il ne sert à rien d'essayer de cacher votre travail ou de garder vos connaissances secrètes 
de peur de perdre votre autorité et/ou votre argent. 
Partager du contenu de valeur est essentiellement ce que recommandent aujourd'hui 
presque tous les gourous du développement personnel. **Si vous partagez du contenu de valeur,** 
**vous montrez que vous êtes bien informé, ce qui, en retour, vous confère autorité et notoriété dans votre domaine.** 
**Et une fois que les gens sauront que vous avez de la valeur parce que vous avez prouvé, encore et encore,** 
**votre capacité à créer du contenu de qualité, ils vous solliciteront également pour des travaux rémunérés.** 

John Sonmez parle de "marketing entrant", qui consiste à "attirer" des clients potentiels 
en offrant gratuitement 90 % de votre valeur ajoutée, 
plutôt que d'essayer d'inciter quelqu'un à acheter un produit. 
**Faites la publicité de vos compétences en offrant gratuitement de la valeur ajoutée et les gens viendront à vous.** 
**Il vous suffit d'être patient et persévérant.** Lorsque les gens viennent à vous, 
vous pouvez facturer des frais plus élevés que lorsque vous essayez de faire acheter à quelqu'un 
un service qu'il ne demandait pas spontanément.

Inversement, personne ne voudra acheter un travail créatif que vous aurez caché pendant des années, 
de peur de ne rien recevoir en retour. 
La créativité et la capacité à améliorer ne viennent pas de la création d'une seule grande œuvre. 
C'est également une opinion générale dans les livres sur le développement personnel. 
Ils citent souvent l'exemple du professeur d'arts plastiques qui a divisé sa classe en deux groupes : 
l'un serait noté sur une production parfaite et l'autre serait simplement noté sur la quantité produite. 
Toutes les très bonnes productions provenaient du groupe "quantité". 
En échouant rapidement et souvent, ils avaient affiné leurs compétences, 
tandis que le groupe "perfection" avait passé tout son temps à théoriser 
et n'avait pas l'expérience nécessaire pour produire des résultats de haute qualité.

Voici où je veux en venir : **si vous enseignez à quelqu'un,** 
**vous lui permettez de faire les choses lui-même.** 
**Les gens aiment se sentir indépendants et ils n'aiment pas que** 
**les experts cachent leur savoir pour forcer les clients à "acheter leurs compétences".** 
Ils aiment qu'on leur permette de comprendre les bases, 
mais ils se rendront compte qu'ils ne sont pas encore capables de faire les choses difficiles tout seuls. 
Ils vous chercheront donc, vous, l'expert qui a fait preuve de compétences 
et d'un véritable dévouement **pour les aider comme ils le souhaitent.** 
**Les clients veulent ce qui est le mieux pour eux, pas ce qui est le mieux pour vous.** 
**Ainsi, lorsque vous essayez d'inciter les clients à acheter chez vous, vous devez répondre à leurs besoins,** 
**et non essayer de les enfumer.** C'est ce que l'on appelle couramment une situation "gagnant-gagnant" : 
vous voulez gagner de l'argent avec votre travail, les clients veulent être aidés de la meilleure façon possible 
(c'est-à-dire de la façon dont ils le souhaitent).


## Conditions préalables et comment démarrer

**Assurez-vous d'abord que vous avez des compétences "actives" en LaTeX,** 
**c'est-à-dire que vous pouvez en faire plus que l'utilisateur moyen.** Comme dans l'enseignement, 
il suffit d'avoir une longueur d'avance sur eux. 
Ensuite, vous pourrez **commencer à aider** les utilisateurs ayant des besoins avancés. 
Assurez-vous de savoir **déboguer les erreurs courantes.**

**Si vous vous voyez plutôt comme un technicien, aidez les utilisateurs de Windows à configurer LaTeX.** 
Cela peut facilement devenir un travail rémunéré. 
Vous vous insérez simplement dans la lignée des assistants techniques. 
De plus, essayez de faire ce travail dans les universités 
où les besoins en matière de composition sont importants (peut-être même en utilisant LaTeX).

**Si vous souhaitez faire quelque chose dans le domaine de la "[conception graphique](wpfr:Graphisme)",** 
**apprenez [TikZ](ctanpkg:pgf) comme si votre vie en dépendait, car ce sera vraiment le cas.**


### Rendre une copie prête pour l'impression

**Ce n'est pas parce que vous connaissez un peu LaTeX que vous saurez nécessairement répondre** 
**aux besoins d'une maison d'édition.** Essayez d'obtenir l'opportunité de travailler avec eux gratuitement. 
Là encore, les petites maisons d'édition ou les éditeurs universitaires offrent 
souvent la possibilité de remettre un PDF final (*prêt-à-clicher*), 
ce qui revient beaucoup moins cher que de le faire mettre en page par leur entremise. 
Cela permettra au scientifique en question d'économiser beaucoup d'argent 
(500 à 2000 € en fonction de la quantité de travail). 
Proposez à un professeur d'université de composer son livre gratuitement. 
insi, vous aurez interagi avec l'éditeur au moins une fois, 
vous aurez une référence à montrer et vous saurez ce que les éditeurs veulent. 
Ne sous-estimez pas non plus le temps que cela va prendre. 
Ce n'est pas pour rien qu'un travail comme celui-ci peut rapporter jusqu'à 2000 €. 
Les publications scientifiques, en particulier, font souvent l'objet d'un million de modifications 
et de corrections avant d'être prêtes à être imprimées. 
**Ce sera probablement beaucoup plus de travail que vous ne l'aviez prévu.** 
**Anticipez cela ! Les maisons d'édition ont également tendance à trouver des problèmes typographiques** 
**auxquels vous n'aviez jamais songé jusque-là.**

[ En écrivant ces lignes, j'ai remarqué que j'aurais beaucoup plus à dire sur la façon de planifier 
et d'aborder le travail avec vos "clients", 
alors j'ai écrit un [billet supplémentaire à ce sujet](/1_generalites/bases/etre_prestataire_de_services_latex)].

Dans les sciences humaines, il est très important que vous appreniez toutes les fonctions offertes par MS Word, 
de façon à pourvoir reproduire un aspect similaire à Word, mais en mieux. 
S'ils vous laissent utiliser LaTeX, 
vous devez d'abord prouver qu'il possède toutes les fonctionnalités de MS Word auxquelles ils sont habitués.

Au cours du processus, vous vous rendrez peut-être compte que produire un PDF qui correspond exactement 
aux critères de l'éditeur est plus difficile que vous ne le pensez. 
En tout cas, c'est ce qui s'est passé pour moi. 
J'avais utilisé LaTeX et je savais comment faire les personnalisations nécessaires pour satisfaire mes encadrants de thèse, 
mais l'éditeur a fini par exiger un million de changements que je n'avais même pas imaginé faire en LaTeX. 
**Mes encadrants étaient contents avec une sortie joliment mise en page et des références bibliographiques correctes.** 
**Les éditeurs, en revanche, veulent une apparence très spécifique.** 
Par exemple, la première chose que j'ai dû changer est la mise en forme des notes de bas de page, 
dont aucun de mes encadrants ne s'était jamais soucié. 
Je n'avais jamais personnalisé de notes de bas de page auparavant 
et je n'avais même pas conscience que cela pouvait être un problème. 
Donc, si vous n'avez jamais fait l'une de ces choses, 
je vous suggère de commencer à vous documenter sur le sujet dès maintenant 
(un prochain billet sur LaTeX pour l’"éditeur par accident" expliquera toutes ces choses).


## L'apprenti sorcier : comment apprendre les ficelles du métier

Si vous n'en êtes qu'au tout début de votre parcours et que vous n'avez pas encore de compétences reconnues, 
n'essayez pas d’"aider" un professionnel. Vous ne feriez que vous ridiculiser. 
Si vous voulez commencer à faire du "vrai travail" le plus rapidement possible, 
**offrez une aide non rémunérée à des non-professionnels.** 
**Soyez honnête sur le fait que vous n'êtes pas encore un professionnel** 
mais que vous aimeriez vraiment faire du travail gratuit pour eux afin de vous constituer un portfolio.

**Apprenez d'un professionnel.** Recherchez un professionnel dont vous savez qu'il utilise LaTeX et portez-vous volontaire. 
Faites le travail qu'il vous délèguera, essayez d'être aussi utile que possible. 
Écoutez très attentivement les informations privilégiées qu'ils ont recueillies au cours de leurs années d'expérience. 
Soyez très ouvert sur le fait que vous n'avez pas encore beaucoup de compétences mais que vous êtes prêt à apprendre. 
Visez un stage (probablement non rémunéré). Cette expérience sera précieuse 
et vous pourrez l'ajouter à la liste des références de votre CV si vous n'avez pas beaucoup de temps à perdre.

**Cependant, si vous voulez vous lancer et décrocher très rapidement des opportunités de travail rémunéré,** 
**essayer de gagner de l'argent en utilisant LaTeX n'est probablement pas la bonne voie pour vous.** 
**Il s'agit plutôt d'un cheminement de carrière vers lequel vous pouvez vous diriger si vous êtes patient,** 
**et que vous vous trouvez dans un environnement adapté à cette quête.**

**Rejoignez un [groupe d'utilisateurs](/1_generalites/documentation/listes_de_discussion/groupes_d_utilisateurs).** 
Là, vous pourrez apprendre des années d'expérience des membres 
et peut-être avoir connaissance d'opportunités d'emplois.


## Où LaTeX est-il utilisé avec possibilités d'emploi ?

### Travail en free-lance

[Upwork](wpfr:Upwork), [Freelancer.com](wp:Freelancer.com)

<https://www.naukri.com/latex-typesetting-jobs>

[Ce billet](https://tex.stackexchange.com/questions/40720/latex-in-industry) traite de LaTeX 
dans l'industrie et donne quelques exemples, au cas où cela vous intéresserait.


### Accès libre, publication électroniques

De nombreuses plateformes de publication électronique utilisent LaTeX pour générer leurs PDF. 
Bien que je ne le connaisse pas personnellement, Lukas C. Bossert crée des solutions LaTeX 
pour l'[Institut archéologique allemand](wpfr:Institut_archéologique_allemand), 
par exemple [un style de citation](ctanpkg:archaeologie). 
Une fois de plus, la conclusion générale est qu'il faut rejoindre une organisation 
qui publie beaucoup et qui a des besoins spécifiques pour lesquels on peut l'aider.


## En résumé

Oui, vous pouvez gagner de l'argent en utilisant LaTeX.

Conseils pratiques : placez-vous dans un environnement universitaire 
où il y a une forte demande de composition mais peu de professionnels de la composition.

Pratiquez LaTeX, apprenez toutes les choses les plus importantes 
(paramètres des citations, mise en forme des notes de bas de page et des bibliographies) 
pour l'édition scientifique, obtenez des références d'une véritable maison d'édition 
afin de pouvoir prouver que vous êtes capable de répondre à leurs besoins.


## Références

- Austin Kleon, [*Steal like an artist*](isbn:978-0761169253), 2012 (édition française : 
[*Voler comme un artiste*](isbn:978-2761941143)).
- John Sonmez, [*The Complete Software Developer’s Career Guide : How to Learn Your Next Programming Language, Ace Your Programming Interview, and Land The Coding Job Of Your Dreams*](isbn:978-0999081419), 2017.
- John Sonmez, [*Soft Skills : The software developer’s life manual*](isbn:978-0999081440), 2014.

(Je ferai bientôt un billet sur le travail de John Sonmez qui donne des conseils très intéressants 
et je vous recommande vivement de lire ses livres. 
Ils sont également disponibles sous forme de livres audio, 
que j'aime écouter en me rendant au travail à vélo. 😉)

Consultez également ces deux articles concernant le travail de consultant LaTeX :

- Boris Veytsman, *TeX consulting for fun and profit*, TUGboat, Volume 32 (2011), No. 1, 
  <https://tug.org/TUGboat/tb32-1/tb100veytsman.pdf>
- Amy Hendrickson, *Real Life LaTeX : Adventures of a TeX Consultant*, 
  TeXNorthEast Conference, March 22–24, 1998. <https://tug.org/TUGboat/tb19-2/tb59amy.pdf>


:::{sources}
- [Earning money with LaTeX?](https://latex-ninja.com/2019/02/02/earning-money-with-latex/)
- [How can I make money from the LaTeX programming language?](https://www.quora.com/How-can-I-make-money-from-the-LaTeX-programming-language)
- [How can I make (some) \$money\$ out of my TeX skills?](https://tex.stackexchange.com/q/135295)
:::
