/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.ml.tools.model.preprocessing;

import com.jetbrains.ml.api.FeaturePreprocessor;
import com.jetbrains.ml.api.feature.Feature;
import com.jetbrains.ml.api.feature.FeatureFilter;
import com.jetbrains.ml.api.model.MLModel;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\b\u0005\u0018\u0000*\b\b\u0000\u0010\u0001*\u00020\u00022\b\u0012\u0004\u0012\u0002H\u00010\u0003B\u001b\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00028\u00000\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J/\u0010\f\u001a\u00028\u00002\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000e2\u0012\u0010\u0010\u001a\u000e\u0012\u0004\u0012\u00020\u0012\u0012\u0004\u0012\u00020\u00020\u0011H\u0016\u00a2\u0006\u0002\u0010\u0013JD\u0010\u0014\u001a\b\u0012\u0004\u0012\u00028\u00000\u000e2\f\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000e2\u0012\u0010\u0016\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u000f0\u000e0\u000e2\u0012\u0010\u0010\u001a\u000e\u0012\u0004\u0012\u00020\u0012\u0012\u0004\u0012\u00020\u00020\u0011H\u0016R\u0014\u0010\b\u001a\u00020\tX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00028\u00000\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0017"}, d2={"Lcom/jetbrains/ml/tools/model/preprocessing/PreprocessingMLModel;", "P", "", "Lcom/jetbrains/ml/api/model/MLModel;", "model", "preprocessor", "Lcom/jetbrains/ml/api/FeaturePreprocessor;", "(Lcom/jetbrains/ml/api/model/MLModel;Lcom/jetbrains/ml/api/FeaturePreprocessor;)V", "knownFeatures", "Lcom/jetbrains/ml/api/feature/FeatureFilter;", "getKnownFeatures", "()Lcom/jetbrains/ml/api/feature/FeatureFilter;", "predict", "features", "", "Lcom/jetbrains/ml/api/feature/Feature;", "parameters", "", "", "(Ljava/util/List;Ljava/util/Map;)Ljava/lang/Object;", "predictBatch", "contextFeatures", "itemFeatures", "ml-tools"})
@SourceDebugExtension(value={"SMAP\nPreprocessingMLModel.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PreprocessingMLModel.kt\ncom/jetbrains/ml/tools/model/preprocessing/PreprocessingMLModel\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,32:1\n1549#2:33\n1620#2,3:34\n*S KotlinDebug\n*F\n+ 1 PreprocessingMLModel.kt\ncom/jetbrains/ml/tools/model/preprocessing/PreprocessingMLModel\n*L\n26#1:33\n26#1:34,3\n*E\n"})
public final class PreprocessingMLModel<P>
implements MLModel<P> {
    @NotNull
    private final MLModel<P> model;
    @NotNull
    private final FeaturePreprocessor preprocessor;
    @NotNull
    private final FeatureFilter knownFeatures;

    public PreprocessingMLModel(@NotNull MLModel<? extends P> model2, @NotNull FeaturePreprocessor preprocessor) {
        Intrinsics.checkNotNullParameter(model2, (String)"model");
        Intrinsics.checkNotNullParameter((Object)preprocessor, (String)"preprocessor");
        this.model = model2;
        this.preprocessor = preprocessor;
        this.knownFeatures = FeatureFilter.Companion.ofDeclarations((Collection)this.preprocessor.getExpectedInputFeatures());
    }

    @NotNull
    public FeatureFilter getKnownFeatures() {
        return this.knownFeatures;
    }

    @NotNull
    public P predict(@NotNull List<? extends Feature> features, @NotNull Map<String, ? extends Object> parameters) {
        Intrinsics.checkNotNullParameter(features, (String)"features");
        Intrinsics.checkNotNullParameter(parameters, (String)"parameters");
        List preprocessedFeatures = FeaturePreprocessor.preprocessFeatures$default((FeaturePreprocessor)this.preprocessor, (Collection)features, null, (int)2, null);
        return (P)this.model.predict(preprocessedFeatures, parameters);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public List<P> predictBatch(@NotNull List<? extends Feature> contextFeatures, @NotNull List<? extends List<? extends Feature>> itemFeatures, @NotNull Map<String, ? extends Object> parameters) {
        void $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter(contextFeatures, (String)"contextFeatures");
        Intrinsics.checkNotNullParameter(itemFeatures, (String)"itemFeatures");
        Intrinsics.checkNotNullParameter(parameters, (String)"parameters");
        Iterable $this$map$iv = itemFeatures;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void features;
            List list = (List)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(this.predict(CollectionsKt.plus((Collection)contextFeatures, (Iterable)((Iterable)features)), parameters));
        }
        return (List)destination$iv$iv;
    }

    @NotNull
    public <T> Map<T, P> predictBatch(@NotNull List<? extends Feature> contextFeatures, @NotNull Map<T, ? extends List<? extends Feature>> itemFeatures, @NotNull Map<String, ? extends Object> parameters) {
        return MLModel.DefaultImpls.predictBatch((MLModel)this, contextFeatures, itemFeatures, parameters);
    }
}

