/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aether.transfer;

import org.eclipse.aether.artifact.Artifact;
import org.eclipse.aether.repository.RemoteRepository;
import org.eclipse.aether.transfer.ArtifactTransferException;

public class ArtifactNotFoundException
extends ArtifactTransferException {
    public ArtifactNotFoundException(Artifact artifact, RemoteRepository repository) {
        super(artifact, repository, ArtifactNotFoundException.getMessage(artifact, repository));
    }

    private static String getMessage(Artifact artifact, RemoteRepository repository) {
        StringBuilder buffer2 = new StringBuilder(256);
        buffer2.append("Could not find artifact ").append(artifact);
        buffer2.append(ArtifactNotFoundException.getString(" in ", repository));
        if (artifact != null) {
            String downloadUrl;
            String localPath = artifact.getProperty("localPath", null);
            if (localPath != null && repository == null) {
                buffer2.append(" at specified path ").append(localPath);
            }
            if ((downloadUrl = artifact.getProperty("downloadUrl", null)) != null) {
                buffer2.append(", try downloading from ").append(downloadUrl);
            }
        }
        return buffer2.toString();
    }

    public ArtifactNotFoundException(Artifact artifact, RemoteRepository repository, String message) {
        super(artifact, repository, message);
    }

    public ArtifactNotFoundException(Artifact artifact, RemoteRepository repository, String message, boolean fromCache) {
        super(artifact, repository, message, fromCache);
    }

    public ArtifactNotFoundException(Artifact artifact, RemoteRepository repository, String message, Throwable cause) {
        super(artifact, repository, message, cause);
    }
}

