# Licensed to Elasticsearch B.V. under one or more contributor
# license agreements. See the NOTICE file distributed with
# this work for additional information regarding copyright
# ownership. Elasticsearch B.V. licenses this file to you under
# the Apache License, Version 2.0 (the "License"); you may
# not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#   http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing,
# software distributed under the License is distributed on an
# "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
# KIND, either express or implied.  See the License for the
# specific language governing permissions and limitations
# under the License.

module Elasticsearch
  module XPack
    module API
      module Fleet
        module Actions
          # Search API where the search will only be executed after specified checkpoints are available due to a refresh. This API is designed for internal use by the fleet server project.
          # This functionality is Experimental and may be changed or removed
          # completely in a future release. Elastic will take a best effort approach
          # to fix any issues, but experimental features are not subject to the
          # support SLA of official GA features.
          #
          # @option arguments [String] :index The index name to search.
          # @option arguments [List] :wait_for_checkpoints Comma separated list of checkpoints, one per shard
          # @option arguments [Time] :wait_for_checkpoints_timeout Explicit wait_for_checkpoints timeout
          # @option arguments [Boolean] :allow_partial_search_results Indicate if an error should be returned if there is a partial search failure or timeout
          # @option arguments [Hash] :headers Custom HTTP headers
          # @option arguments [Hash] :body The search definition using the Query DSL
          #
          # @see [TODO]
          #
          def search(arguments = {})
            raise ArgumentError, "Required argument 'index' missing" unless arguments[:index]

            headers = arguments.delete(:headers) || {}

            arguments = arguments.clone
            arguments[:index] = UNDERSCORE_ALL if !arguments[:index] && arguments[:type]

            _index = arguments.delete(:index)

            method = if arguments[:body]
                       Elasticsearch::API::HTTP_POST
                     else
                       Elasticsearch::API::HTTP_GET
                     end

            path   = "#{Elasticsearch::API::Utils.__listify(_index)}/_fleet/_fleet_search"
            params = Elasticsearch::API::Utils.__validate_and_extract_params arguments, ParamsRegistry.get(__method__)

            body = arguments[:body]
            perform_request(method, path, params, body, headers).body
          end

          # Register this action with its valid params when the module is loaded.
          #
          # @since 6.2.0
          ParamsRegistry.register(:search, [
            :wait_for_checkpoints,
            :wait_for_checkpoints_timeout,
            :allow_partial_search_results
          ].freeze)
        end
      end
    end
  end
end
